/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.unix;

import com.urbancode.commons.util.Check;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;

class TempFileBuilder {
    private static final String DIGITS = "0123456789";
    private final SecureRandom random = new SecureRandom();
    private int digitCount = 10;

    TempFileBuilder() {
    }

    public int getDigitCount() {
        return this.digitCount;
    }

    public void setDigitCount(int digitCount) {
        Check.positive((int)digitCount, (String)"digitCount");
        this.digitCount = digitCount;
    }

    public File build(String prefix, String suffix) throws IOException {
        return this.build(prefix, suffix, null);
    }

    public File build(String prefix, String suffix, File parent) throws IOException {
        File result = null;
        if (parent == null) {
            parent = new File(System.getProperty("java.io.tmpdir"));
        }
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        boolean newFileCreated = false;
        while (!newFileCreated) {
            result = this.createFile(prefix, suffix, parent);
            newFileCreated = result.createNewFile();
        }
        assert (result != null);
        return result;
    }

    File createFile(String prefix, String suffix, File parent) {
        int digitCount = this.digitCount;
        char[] randomChars = new char[digitCount];
        for (int i = 0; i < digitCount; ++i) {
            randomChars[i] = this.getDigitChar();
        }
        String randomString = new String(randomChars);
        return new File(parent, prefix + randomString + suffix);
    }

    private synchronized char getDigitChar() {
        return DIGITS.charAt(this.random.nextInt(DIGITS.length()));
    }
}

