/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.unix;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.commons.util.unix.UnixCommandUnavailableException;
import com.urbancode.process.NativeProcess;
import com.urbancode.process.jdk7.ProcessBuilder;
import com.urbancode.shell.impersonation.ImpersonateCommand;
import com.urbancode.shell.impersonation.ImpersonationToken;
import com.urbancode.shell.impersonation.unix.NativeProcessActions;
import com.urbancode.shell.impersonation.unix.NativeProcessPostExecuteAction;
import com.urbancode.shell.impersonation.unix.SuScriptGenerator;
import com.urbancode.shell.impersonation.unix.TempFileBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixImpersonateCommand
implements ImpersonateCommand {
    private static final Logger log = Logger.getLogger(UnixImpersonateCommand.class);
    private final ImpersonationToken impersonationToken;
    private final List<String> commandLine;
    private final String workDir;
    private final Map<String, String> environment;
    private final ProcessBuilder.Redirect redirectInput;
    private final ProcessBuilder.Redirect redirectOutput;
    private final ProcessBuilder.Redirect redirectError;
    private final Unix unix = new Unix();
    private final int scriptMode = Integer.parseInt(System.getProperty("com.urbancode.shell.impersonation.unix.scriptMode", "0777"), 8);
    private final File scriptLocation = new File(System.getProperty("com.urbancode.shell.impersonation.unix.scriptLocation", System.getProperty("java.io.tmpdir")));
    private final String scriptPreExecuteAction = System.getProperty("com.urbancode.shell.impersonation.unix.scriptPreExecuteAction");
    private final String scriptPostExecuteAction = System.getProperty("com.urbancode.shell.impersonation.unix.scriptPostExecuteAction");
    private final String sudoImpersonationFormat = System.getProperty("com.urbancode.shell.impersonation.unix.sudoFormat", "%s -n -u %u %c");
    private final String sudoGroupImpersonationFormat = System.getProperty("com.urbancode.shell.impersonation.unix.sudoGroupFormat", "%s -n -u %u -g %g %c");
    private final String suImpersonationFormat = System.getProperty("com.urbancode.shell.impersonation.unix.suFormat", "%s - %u -c %c");

    private static TempFileBuilder getTempFileBuilder() {
        return TempFileBuilderInitializer.instance;
    }

    private static Charset getCharset() {
        return CharsetInitializer.charset;
    }

    public UnixImpersonateCommand(ImpersonationToken impersonationToken, List<String> commandLine, String workDir, Map<String, String> environment, ProcessBuilder.Redirect redirectInput, ProcessBuilder.Redirect redirectOutput, ProcessBuilder.Redirect redirectError) {
        ProcessBuilder.Redirect.Type errorType;
        if (impersonationToken == null) {
            throw new NullPointerException("impersonationToken");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        if (workDir == null) {
            throw new NullPointerException("workDir");
        }
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        if (redirectInput == null) {
            throw new NullPointerException("redirectInput");
        }
        ProcessBuilder.Redirect.Type inputType = redirectInput.type();
        if (inputType != ProcessBuilder.Redirect.Type.PIPE && inputType != ProcessBuilder.Redirect.Type.READ) {
            throw new IllegalArgumentException("Invalid input redirect");
        }
        if (redirectOutput == null) {
            throw new NullPointerException("redirectOutput");
        }
        ProcessBuilder.Redirect.Type outputType = redirectOutput.type();
        if (outputType != ProcessBuilder.Redirect.Type.PIPE && outputType != ProcessBuilder.Redirect.Type.WRITE && outputType != ProcessBuilder.Redirect.Type.APPEND) {
            throw new IllegalArgumentException("Invalid output redirect");
        }
        if (redirectError != null && (errorType = redirectError.type()) != ProcessBuilder.Redirect.Type.PIPE && errorType != ProcessBuilder.Redirect.Type.WRITE && errorType != ProcessBuilder.Redirect.Type.APPEND) {
            throw new IllegalArgumentException("Invalid error redirect");
        }
        if (commandLine.size() < 1) {
            throw new IllegalArgumentException("commandLine empty");
        }
        this.impersonationToken = impersonationToken;
        this.commandLine = Collections.unmodifiableList(new ArrayList<String>(commandLine));
        this.workDir = workDir;
        this.environment = Collections.unmodifiableMap(new HashMap<String, String>(environment));
        this.redirectInput = redirectInput;
        this.redirectOutput = redirectOutput;
        this.redirectError = redirectError;
    }

    @Override
    public NativeProcess execute() throws IOException {
        String user = this.impersonationToken.getUser();
        File suScript = UnixImpersonateCommand.getTempFileBuilder().build("command-script-", ".sh", this.scriptLocation);
        try {
            this.unix.chown(suScript, user);
            this.unix.chmod(suScript, 448);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Impersonation chown failed for script: " + e.getMessage()));
                log.debug((Object)("Applying chmod " + this.scriptMode + " to temp script"));
            }
            this.unix.chmod(suScript, this.scriptMode);
        }
        HashMap<String, String> env = new HashMap<String, String>(this.environment);
        if (!env.containsKey("JAVA_HOME")) {
            env.put("JAVA_HOME", System.getProperty("java.home"));
        }
        if (!env.containsKey("DS_SYSTEM_ENCODING")) {
            env.put("DS_SYSTEM_ENCODING", UnixImpersonateCommand.getCharset().toString());
        }
        SuScriptGenerator generator = new SuScriptGenerator(this.unix, this.commandLine, env, new File(this.workDir), UnixImpersonateCommand.getCharset());
        generator.writeTo(suScript);
        if (this.scriptPreExecuteAction != null && this.scriptPreExecuteAction.trim().length() > 0) {
            NativeProcessActions.runPreExecuteAction(suScript, this.scriptPreExecuteAction, user, this.scriptLocation, this.workDir);
        }
        String impersonatedCommand = suScript.getAbsolutePath();
        String[] command = this.impersonationToken.isUseSudo() ? this.createSudoCommand(user, impersonatedCommand) : this.createSuCommand(user, impersonatedCommand);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running command as Unix user " + user));
            log.debug((Object)("Command: " + Arrays.asList(command)));
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectInput(this.redirectInput);
        builder.redirectOutput(this.redirectOutput);
        if (this.redirectError != null) {
            builder.redirectError(this.redirectError);
        } else {
            builder.redirectErrorStream(true);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Command: " + builder.command()));
            log.trace((Object)("Work dir: " + builder.directory()));
            log.trace((Object)("Input: " + builder.redirectInput()));
            log.trace((Object)("Output: " + builder.redirectOutput()));
            if (builder.redirectErrorStream()) {
                log.trace((Object)"Error: merge");
            } else {
                log.trace((Object)("Error: " + builder.redirectError()));
            }
            log.trace((Object)("Environment: " + builder.environment()));
        }
        NativeProcess delegate = null;
        try {
            delegate = (NativeProcess)builder.start();
        }
        catch (IOException e) {
            StringBuilder commandString = new StringBuilder();
            for (String argument : command) {
                commandString.append(argument);
            }
            log.error((Object)("Could not start " + commandString));
            log.debug((Object)"Running scriptPostExecuteAction");
            NativeProcessActions.runPostExecuteAction(suScript, this.scriptPostExecuteAction, user, this.workDir);
            throw e;
        }
        return new NativeProcessPostExecuteAction(delegate, suScript, this.scriptPostExecuteAction, user, this.workDir);
    }

    private String[] createSuCommand(String user, String impersonatedCommand) throws UnixCommandUnavailableException {
        String[] command = this.suImpersonationFormat.split(" ");
        for (int i = 0; i < command.length; ++i) {
            if (command[i].equals("%s")) {
                command[i] = this.unix.suPath();
                continue;
            }
            if (command[i].equals("%u")) {
                command[i] = user;
                continue;
            }
            if (!command[i].equals("%c")) continue;
            command[i] = impersonatedCommand;
        }
        return command;
    }

    private String[] createSudoCommand(String user, String impersonatedCommand) throws UnixCommandUnavailableException {
        String[] command;
        String group = this.impersonationToken.getGroup();
        if (group == null || group.trim().length() == 0) {
            command = this.sudoImpersonationFormat.split(" ");
            for (int i = 0; i < command.length; ++i) {
                if (command[i].equals("%s")) {
                    command[i] = this.unix.sudoPath();
                    continue;
                }
                if (command[i].equals("%u")) {
                    command[i] = user;
                    continue;
                }
                if (!command[i].equals("%c")) continue;
                command[i] = impersonatedCommand;
            }
        } else {
            command = this.sudoGroupImpersonationFormat.split(" ");
            for (int i = 0; i < command.length; ++i) {
                if (command[i].equals("%s")) {
                    command[i] = this.unix.sudoPath();
                    continue;
                }
                if (command[i].equals("%u")) {
                    command[i] = user;
                    continue;
                }
                if (command[i].equals("%c")) {
                    command[i] = impersonatedCommand;
                    continue;
                }
                if (!command[i].equals("%g")) continue;
                command[i] = group;
            }
        }
        return command;
    }

    private static final class CharsetInitializer {
        private static final Charset charset;

        private CharsetInitializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Properties loadProps(File file) throws IOException {
            Method loadWithReader;
            try {
                loadWithReader = Properties.class.getMethod("load", Reader.class);
            }
            catch (Exception e) {
                loadWithReader = null;
            }
            Properties props = null;
            if (loadWithReader != null) {
                Properties p = new Properties();
                InputStreamReader in = IO.reader((File)file);
                try {
                    loadWithReader.invoke((Object)p, in);
                    props = p;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Failed to load properties with load(Reader)", (Throwable)e);
                    }
                }
                finally {
                    ((Reader)in).close();
                }
            }
            if (props == null) {
                props = new Properties();
                FileInputStream in = new FileInputStream(file);
                try {
                    props.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            return props;
        }

        static {
            Charset ch;
            block5: {
                ch = null;
                try {
                    File file = new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties");
                    Properties props = CharsetInitializer.loadProps(file);
                    ch = Charset.forName(props.getProperty("system.default.encoding"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Charset is: " + ch.name()));
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)"There was an exception getting the charset: ", (Throwable)e);
                }
            }
            if (ch == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not get a Charset from the agent's installed.properties, using UTF-8");
                }
                ch = IO.utf8();
            }
            charset = ch;
        }
    }

    private static final class TempFileBuilderInitializer {
        private static final TempFileBuilder instance = new TempFileBuilder();

        private TempFileBuilderInitializer() {
        }
    }
}

