/*
 * Licensed Materials - Property of HCL
 * UrbanCode Deploy
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * Trademark of HCL Technologies Limited
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.infosphere.ISDHelper

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
String action = this.args[2]    // runtimeimport or designtimeimport

File workDir = new File('.').canonicalFile

/* Properties that are common to both design time and runtime exports */
String importExport = props['importExport']?.trim()
String username = props['username']?.trim()
String password = props['password']?.trim()
String input = props['input']?.trim()
boolean replace = Boolean.parseBoolean(props['replace'])

ISDHelper isdHelper = new ISDHelper(importExport, workDir, username, password)
List<String> additionalArgs = isdHelper.getCommandArgs(props['additionalArgs'])
int exitCode = 0

if (additionalArgs) {
    isdHelper.setAdditionalArgs(additionalArgs)
}

if ("runtimeimport".equals(action)) {
    exitCode = isdHelper.doRuntimeImport(action, input, replace)
}
else {
    /* Properties that are only relevant with design time imports */
    String project = props['project']?.trim()
    List<String> applications = props['applications']?.tokenize("[\n,]")*.trim()
    List<String> services = props['services']?.tokenize("[\n,]")*.trim()

    exitCode = isdHelper.doDesignImport(action, project, applications, services, input, replace)
}

if (exitCode) {
    println("[Error] The import process has failed.")
}
else {
    println("[OK] The import process has completed successfully.")
}

System.exit(exitCode)
