/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.groovy.GroovyUtil;
import com.urbancode.commons.util.concurrent.WaitFuture;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.shell.Shell;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class JavaShell {
    final String lineSep = System.getProperty("line.separator");
    private Properties inputProperties;

    public JavaShell(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() {
        File scriptFile;
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        String pathSep = System.getProperty("path.separator");
        boolean windows = GroovyUtil.matches(osName, "windows");
        boolean vms = GroovyUtil.matches(osName, "vms");
        boolean os9 = GroovyUtil.matches(osName, "mac") && !osName.endsWith("x");
        boolean unix = pathSep.startsWith(":") && !vms && !os9;
        boolean zos = GroovyUtil.matches(osName, "z\\/os");
        boolean ibmi = GroovyUtil.matches(osName, "os\\/400");
        File PLUGIN_HOME = new File(System.getenv().get("PLUGIN_HOME"));
        String DEFAULT_SHELL = System.getenv().get("SHELL");
        File AGENT_HOME = null;
        if (System.getenv().containsKey("AGENT_HOME")) {
            AGENT_HOME = new File(System.getenv().get("AGENT_HOME"));
        }
        Processes processes = new Processes();
        if (windows) {
            String arch = this.getArch();
            File libraryPath = new File(PLUGIN_HOME, "lib/native/${arch}/WinAPI.dll");
            System.setProperty("com.urbancode.winapi.WinAPI.dllPath", libraryPath.getAbsolutePath());
        }
        File workDir = null;
        String defaultCharset = null;
        if (AGENT_HOME != null) {
            File agentInstalledProps = new File(AGENT_HOME, "conf/agent/installed.properties");
            Properties agentProps = new Properties();
            FileInputStream agentInputStream = null;
            try {
                workDir = new File(".").getCanonicalFile();
                agentInputStream = new FileInputStream(agentInstalledProps);
                agentProps.load(agentInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            defaultCharset = agentProps.getProperty("system.default.encoding");
        }
        String directoryOffset = this.inputProperties.getProperty("directoryOffset");
        boolean runAsDaemon = Boolean.valueOf(this.inputProperties.getProperty("runAsDaemon"));
        String interpreter = this.inputProperties.getProperty("shellInterpreter");
        String scriptBody = this.inputProperties.getProperty("scriptBody");
        String outputFilePath = this.inputProperties.getProperty("outputFile");
        boolean verbose = false;
        int exitCode = -1;
        if (directoryOffset != null || directoryOffset.isEmpty()) {
            try {
                workDir = new File(workDir, directoryOffset).getCanonicalFile();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (workDir.isFile()) {
            throw new IllegalArgumentException("Working directory " + workDir + " is a file!");
        }
        if (scriptBody == null || scriptBody.isEmpty()) {
            throw new IllegalArgumentException("Shell Script is required");
        }
        boolean daemon = false;
        if (vms) {
            daemon = runAsDaemon;
        }
        String scriptExt = null;
        if (interpreter == null || interpreter.isEmpty()) {
            if (windows) {
                scriptExt = ".bat";
            } else if (vms) {
                scriptExt = ".com";
                List<String> paths = GroovyUtil.tokenize(workDir.getPath(), "/");
                String buf = paths.get(0) + ':';
                List<String> directories = GroovyUtil.listTail(paths);
                if (directories != null && !directories.isEmpty()) {
                    buf = buf + '[' + StringUtils.join(directories, (String)".") + ']';
                }
                scriptBody = "$ SET DEFAULT " + buf + "\n$ " + scriptBody;
            } else if (unix) {
                boolean isRexx = false;
                if (zos && scriptBody.startsWith("/*") && scriptBody.toLowerCase().contains("rexx")) {
                    scriptBody = scriptBody + "\n";
                    isRexx = true;
                }
                if (!scriptBody.startsWith("#!") && !isRexx) {
                    interpreter = "/bin/sh";
                }
                if (ibmi) {
                    interpreter = "/QOpenSys/usr/bin/sh";
                }
            } else {
                interpreter = DEFAULT_SHELL;
            }
        }
        File outputFile = null;
        if (outputFilePath != null && !outputFilePath.trim().isEmpty() && !(outputFile = new File(outputFilePath = outputFilePath.trim())).isAbsolute()) {
            outputFile = new File(workDir, outputFile.getPath()).getAbsoluteFile();
        }
        workDir.mkdirs();
        String tempExt = scriptExt;
        if (tempExt == null || !tempExt.isEmpty()) {
            tempExt = ".tmp";
        }
        try {
            scriptFile = File.createTempFile("shell_command_", tempExt);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            if (defaultCharset != null && !defaultCharset.isEmpty()) {
                GroovyUtil.writeToFile(scriptFile, this.denormalizeLines(scriptBody), defaultCharset);
            } else {
                GroovyUtil.writeToFile(scriptFile, this.denormalizeLines(scriptBody));
            }
            if (unix) {
                int c;
                String[] cmdArgs = new String[]{"chmod", "+x", scriptFile.getAbsolutePath()};
                ProcessBuilder pb = new ProcessBuilder(cmdArgs);
                pb.redirectErrorStream(true);
                Process chmod = pb.start();
                InputStream is = chmod.getInputStream();
                while ((c = is.read()) != -1) {
                    System.out.print((char)c);
                }
                chmod.getOutputStream().close();
                try {
                    chmod.waitFor();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ArrayList<String> commandLine = new ArrayList<String>();
            if (interpreter != null && !interpreter.isEmpty()) {
                if (windows) {
                    commandLine.add("cmd");
                    commandLine.add("/C");
                    commandLine.add(interpreter);
                } else {
                    commandLine.addAll(GroovyUtil.tokenize(interpreter, " "));
                }
            }
            commandLine.add(scriptFile.getAbsolutePath());
            Shell shell = new Shell(commandLine.toArray(new String[commandLine.size()]));
            shell.setWorkingDirectory(workDir);
            shell.setDaemon(daemon);
            shell.setOutputFile(outputFile);
            System.out.println("");
            System.out.println("command line: " + StringUtils.join(commandLine, (String)" "));
            System.out.println("script content: ");
            System.out.println("-------------------------------");
            System.out.println(scriptBody);
            System.out.println("-------------------------------");
            System.out.println("working directory: " + workDir.getPath());
            if (daemon) {
                String message = "running as daemon: output ";
                message = outputFile != null ? message + "redirected to " + outputFile.getPath() : message + "discarded";
                System.out.println(message);
            } else {
                System.out.println("===============================");
                System.out.println("command output: ");
            }
            Process proc = null;
            if (vms) {
                proc = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]));
            } else {
                shell.execute();
                proc = shell.getProcess();
            }
            final Process runningProc = proc;
            if (!daemon) {
                Thread hook = new Thread(){

                    @Override
                    public void run() {
                        runningProc.destroy();
                    }
                };
                Runtime.getRuntime().addShutdownHook(hook);
                Class.forName("com.urbancode.commons.util.IO");
                proc.getOutputStream().close();
                WaitFuture outFuture = processes.redirectOutput(proc, System.out);
                WaitFuture errFuture = processes.redirectError(proc, System.err);
                outFuture.await();
                errFuture.await();
                proc.waitFor();
                Runtime.getRuntime().removeShutdownHook(hook);
                exitCode = proc.exitValue();
                System.out.println("===============================");
                System.out.println("command exit code: " + exitCode);
                System.out.println("");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (!daemon) {
                scriptFile.delete();
            }
        }
        if (!daemon) {
            System.exit(exitCode);
        }
        return 0;
    }

    private String getArch() {
        String result = null;
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
        result = arch.indexOf("amd64") > -1 || arch.indexOf("x64") > -1 || arch.indexOf("x86_64") > -1 ? "x64" : (arch.indexOf("x86") > -1 || arch.indexOf("386") > -1 || arch.indexOf("486") > -1 || arch.indexOf("586") > -1 || arch.indexOf("686") > -1 || arch.indexOf("pentium") > -1 ? "x86" : (arch.indexOf("ia64") > -1 || arch.indexOf("itanium") > -1 || arch.indexOf("ia-64") > -1 ? "ia64" : (arch.indexOf("ppc") > -1 || arch.indexOf("powerpc") > -1 ? "ppc" : (arch.indexOf("sparc") > -1 ? "sparc" : (arch.indexOf("parisc") > -1 || arch.indexOf("pa_risc") > -1 || arch.indexOf("pa-risc") > -1 ? "parisc" : (arch.indexOf("alpha") > -1 ? "alpha" : (arch.indexOf("mips") > -1 ? "mips" : (arch.indexOf("arm") > -1 ? "arm" : "unknown"))))))));
        return result;
    }

    private String denormalizeLines(String value) {
        return value.replaceAll("\\n|\\r\\n|\\r", Matcher.quoteReplacement(this.lineSep));
    }
}

