/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.kubernetes.KubernetesHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()
String url       = inProps['url']
String username  = inProps['username']
String password  = inProps['password']
String namespace = inProps['namespace']
String home      = inProps['home']
String globals   = inProps['globals']
String flags     = inProps['flags']
String type      = inProps['type']
String resources = inProps['resources']

// Set up helper
File workDir = new File(".").canonicalFile
KubernetesHelper kh = new KubernetesHelper(workDir, home)

// Step specific commands
ArrayList args = []
kh.setGlobals(args, url, username, password, namespace, globals)
args << 'delete'
if (type.equals('filename')) {
    args << '-f'
    resources.split('\\s+').each() { resource ->
        if (resource) {
            args << resource
        }
    }
}
else if (type.equals('names')) {
    resources.split('\\s+').each() { resource ->
        if (resource) {
            args << resource
        }
    }
}
else if (type.equals('labels')) {
    resources = resources.split('\\s+')
    args << resources[0]
    args << '-l'
    args << resources[1]
}
else if (type.equals('all')) {
    resources.split('\\s+').each() { resource ->
        if (resource) {
            args << resource
        }
    }
    args << '--all'
}
kh.setFlags(args, flags)
if (kh.runCommand('[action]  Deleting resource...', args, 'Deleted resource.', 'Could not delete resource.')) {
    System.exit(0)
}
else {
    System.exit(1)
}