/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.kubernetes.KubernetesHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()
String url       = inProps['url']
String username  = inProps['username']
String password  = inProps['password']
String namespace = inProps['namespace']
String home      = inProps['home']
String globals   = inProps['globals']
String flags     = inProps['flags']
String type      = inProps['type']
String resource  = inProps['resource']

// Set up helper
File workDir = new File(".").canonicalFile
KubernetesHelper kh = new KubernetesHelper(workDir, home)

// Step specific commands
ArrayList args = []
kh.setGlobals(args, url, username, password, namespace, globals)
args << 'expose'
if (type.equals('filename')) {
    args << '-f'
}
else if (type.equals('rc')) {
    args << 'rc'
}
else if (type.equals('service')) {
    args << 'service'
}
else if (type.equals('pod')) {
    args << 'pod'
}
args << resource
kh.setFlags(args, flags)
if (kh.runCommand('[action]  Exposing resource...', args, 'Exposed resource.', 'Could not expose resource.')) {
    System.exit(0)
}
else {
    System.exit(1)
}