/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.nonull.NonNull;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class NonNullSequentialList<E>
extends AbstractSequentialList<E>
implements Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final List<E> delegate;

    NonNullSequentialList(List<E> delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    @Override
    public E set(int index, E element) {
        Check.nonNull(element, "element");
        return this.delegate.set(index, element);
    }

    @Override
    public boolean add(E element) {
        Check.nonNull(element, "element");
        return this.delegate.add(element);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new NonNullListIterator<E>(this.delegate.listIterator(index));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static final class NonNullListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> delegate;

        NonNullListIterator(ListIterator<E> delegate) {
            this.delegate = Check.nonNull(delegate, "delegate");
        }

        @Override
        public void add(E element) {
            Check.nonNull(element, "element");
            this.delegate.add(element);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public E previous() {
            return this.delegate.previous();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(E element) {
            Check.nonNull(element, "element");
            this.delegate.set(element);
        }
    }
}

