/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.kubernetes.KubernetesHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()
String url       = inProps['url']
String username  = inProps['username']
String password  = inProps['password']
String namespace = inProps['namespace']
String path      = inProps['path']
String globals   = inProps['globals']
String flags     = inProps['flags']
String filename  = inProps['filename']

// Set up helper
File workDir = new File(".").canonicalFile
KubernetesHelper kh = new KubernetesHelper(workDir, path)

// Step specific commands
ArrayList args = []
kh.setGlobals(args, url, username, password, namespace, globals)
args << 'create'
args << '--filename=' + filename
kh.setFlags(args, flags)
if (kh.runCommand('[action]  Creating resource...', args, 'Created resource.', 'Could not create resource.')) {
    System.exit(0)
}
else {
    System.exit(1)
}