/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

public class DownloadVersionFilesCommand {
    private String baseUrl;
    private String component;
    private String version;
    private String location;
    private String singleFilePath;
    private HttpClient client;

    public DownloadVersionFilesCommand(String baseUrl, HttpClient client, String component, String version, String location, String singleFilePath) {
        this.baseUrl = baseUrl.replaceAll("/+$", "");
        this.component = component;
        this.version = version;
        this.client = client;
        this.location = location;
        this.singleFilePath = singleFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        File download;
        File parent;
        System.out.print("[#         ]\r");
        String fileName = "";
        String url = this.getUrl("/downloadArtifacts", "version", this.version, "component", this.component, "location", this.location, "singleFilePath", this.singleFilePath);
        if (StringUtils.isEmpty(this.singleFilePath)) {
            if (!StringUtils.isEmpty(this.component)) {
                fileName = fileName + this.component + "_";
            }
            fileName = fileName + this.version + "_artifacts.zip";
        } else {
            fileName = this.singleFilePath;
            int i = this.singleFilePath.lastIndexOf(47);
            if (i >= 0) {
                fileName = this.singleFilePath.substring(i + 1);
            }
        }
        HttpGet method = new HttpGet(url);
        System.out.println("Downloading...");
        if (!StringUtils.isEmpty(this.location) && !this.location.endsWith(File.separator)) {
            this.location = this.location + File.separator;
        }
        String filePath = fileName;
        if (this.location != null) {
            filePath = this.location + fileName;
        }
        if ((parent = (download = new File(filePath)).getParentFile()) != null) {
            parent.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(download);
        System.out.print("[##        ]\r");
        HttpResponse response = this.client.execute(method);
        HttpEntity entity = response.getEntity();
        InputStream inputStream = entity.getContent();
        System.out.print("[###       ]\r");
        IO.copy(inputStream, (OutputStream)fos);
        System.out.print("[######### ]\r");
        int code = response.getStatusLine().getStatusCode();
        try {
            if (code < 200 || code >= 300) {
                String message = EntityUtils.toString(response.getEntity(), IO.utf8());
                throw new Exception("Request error: " + code + ": " + message);
            }
            System.out.print("[##########]\n");
        }
        finally {
            method.releaseConnection();
            System.out.println("Completed.\n\nDownloaded to " + download.getAbsolutePath());
        }
    }

    private String getUrl(String path, Object ... parameters) throws Exception {
        this.baseUrl = this.baseUrl.replaceAll("/+$", "");
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseUrl);
        sb.append("/cli/version");
        sb.append(path);
        if (parameters != null && parameters.length > 0) {
            sb.append('?');
            for (int i = 0; i < parameters.length; i += 2) {
                if (parameters[i + 1] == null) continue;
                sb.append(URLEncoder.encode(parameters[i].toString(), "UTF-8"));
                sb.append('=');
                sb.append(URLEncoder.encode(parameters[i + 1].toString(), "UTF-8"));
                sb.append('&');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

