/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
 import com.urbancode.air.AirPluginTool
 import com.urbancode.air.plugin.kubernetes.KubernetesHelper

 // Get step properties
 AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
 Properties inProps   = apTool.getStepProperties()
 String cluster       = inProps['cluster']?.trim();
 String flags         = inProps['flags']?.trim();
 String path          = inProps['path'].trim();
 String kubeconfig    = inProps['kubeconfig'].trim();

 // Set up helper
 if (!path) {
   path = "helm"
 }
 File workDir = new File(".").canonicalFile
 KubernetesHelper kh = new KubernetesHelper(workDir, path)
 if (kubeconfig) {
   kh.addEnvironmentVariable("KUBECONFIG", kubeconfig);
 }

 // Step specific commands
 ArrayList args = []
 args << 'init'
 if (cluster) {
   args << '--kube-context'
   args << cluster
 }
 kh.setFlags(args, flags)
 if (kh.runCommand('[action] Initializing Helm', args, 'Helm initialized', 'Could not initialize Helm')) {
     System.exit(0)
 }
 else {
     System.exit(1)
 }