/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.sql;

import com.urbancode.commons.util.query.QueryResult;
import com.urbancode.commons.util.sql.ResultSetProxyGenerator;
import com.urbancode.commons.util.sql.ResultSetReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public abstract class AbstractSqlPaginator {
    private static final Logger log = Logger.getLogger(AbstractSqlPaginator.class);
    protected static final int MAX_FETCH_SIZE = 1000;
    private final Connection connection;
    private long startRecord = 0L;
    private int maxRecords = 100;
    private boolean forceTotalCount = false;
    private DBTYPE dbType = null;

    public AbstractSqlPaginator(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public long getStartRecord() {
        return this.startRecord;
    }

    public void setStartRecord(long startRecord) {
        this.startRecord = startRecord;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public boolean isForceTotalCount() {
        return this.forceTotalCount;
    }

    public void setForceTotalCount(boolean forceTotalCount) {
        this.forceTotalCount = forceTotalCount;
    }

    private DBTYPE getCurrentDBType() throws SQLException {
        if (this.dbType == null) {
            this.dbType = this.getDBType(this.connection);
        }
        return this.dbType;
    }

    protected DBTYPE getDBType(Connection connection) throws SQLException {
        DatabaseMetaData md = connection.getMetaData();
        String dbProductName = md.getDatabaseProductName();
        int major = md.getDatabaseMajorVersion();
        DBTYPE dbType = DBTYPE.getByProductName(dbProductName, major);
        return dbType;
    }

    protected String addOffsetLimit(DBTYPE type, String sql, long startRecord, int maxRows) {
        String resultSql;
        if (maxRows > 100000 && startRecord == 0L) {
            return sql;
        }
        Validate.notNull(type);
        Validate.notBlank(sql);
        Validate.isTrue(startRecord >= 0L, "startRecord must be >= 0 (was %d)", startRecord);
        Validate.isTrue(maxRows > 0, "maxrows must be > 0 (was %d)", maxRows);
        Pattern p = Pattern.compile("(?is)\\bORDER\\s+BY\\b.*");
        Matcher m = p.matcher(sql);
        Validate.isTrue(m.find(), "query lacks required order-by clause: %s", sql);
        String orderBy = m.group();
        orderBy = orderBy.replaceAll("[\\w]+\\.", "LIMIT_98843777.");
        if (maxRows < Integer.MAX_VALUE) {
            ++maxRows;
        }
        String noOffsetSqlFmt = "";
        noOffsetSqlFmt = noOffsetSqlFmt + "SELECT * FROM ( ";
        noOffsetSqlFmt = noOffsetSqlFmt + " SELECT LIMIT_98843777.*, ROW_NUMBER() OVER ( ";
        noOffsetSqlFmt = noOffsetSqlFmt + " %s ";
        noOffsetSqlFmt = noOffsetSqlFmt + " ) ROWNUM_98843777 ";
        noOffsetSqlFmt = noOffsetSqlFmt + " FROM ( %n %s %n ) LIMIT_98843777 ";
        noOffsetSqlFmt = noOffsetSqlFmt + " ) OUTER_LIMIT_98843777 ";
        noOffsetSqlFmt = noOffsetSqlFmt + " WHERE ROWNUM_98843777 BETWEEN %d AND %d";
        switch (type) {
            case DERBY: 
            case SQLSERVER: 
            case ORACLE: {
                resultSql = sql + " OFFSET " + startRecord + " ROWS FETCH NEXT " + maxRows + " ROWS ONLY";
                break;
            }
            case MYSQL: 
            case POSTGRES: {
                resultSql = sql + " LIMIT " + maxRows + " OFFSET " + startRecord;
                break;
            }
            case SQLSERVER_2008: {
                resultSql = String.format(noOffsetSqlFmt, orderBy, sql.replaceFirst("(?i)SELECT(?:\\s+DISTINCT)?\\b", "$0 TOP 100 PERCENT "), startRecord + 1L, startRecord + (long)maxRows);
                break;
            }
            case ORACLE_11G: {
                resultSql = String.format(noOffsetSqlFmt, orderBy, sql, startRecord + 1L, startRecord + (long)maxRows);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown database type " + (Object)((Object)type));
            }
        }
        return resultSql;
    }

    protected String getCountSql(DBTYPE type, String sql) throws SQLException {
        Validate.notNull(type);
        Validate.notBlank(sql);
        assert (AbstractSqlPaginator.doesNotContainPattern(sql, "\\bHAVING\\b"));
        assert (AbstractSqlPaginator.doesNotContainPattern(sql, "\\bGROUP\\b"));
        assert (AbstractSqlPaginator.doesNotContainPattern(sql, "\\bOFFSET\\b"));
        assert (AbstractSqlPaginator.doesNotContainPattern(sql, "\\bLIMIT\\b"));
        String resultSql = sql.replaceFirst("(?ims)SELECT\\b.*?\\bFROM\\b", "SELECT COUNT(1) FROM");
        resultSql = resultSql.replaceFirst("(?ims)\\s*\\bORDER\\s+BY\\b.*", "");
        return resultSql;
    }

    private static boolean doesNotContainPattern(String value, String pattern) {
        Pattern p = Pattern.compile(pattern, 42);
        Matcher m = p.matcher(value);
        return !m.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Q> QueryResult<Q> restoreQueryResult(String sql, List<Object> params, ResultSetReader<Q> reader) throws SQLException {
        Validate.isTrue(this.startRecord >= 0L, "start record must be >=0", new Object[0]);
        Validate.isTrue(this.maxRecords > 0, "max records must be >0", new Object[0]);
        int fetchSize = Math.min(this.maxRecords, 1000) + 1;
        QueryResult result = new QueryResult(this.startRecord);
        result.setTotalRecords(-1L);
        ArrayList<Q> resultList = new ArrayList<Q>(fetchSize);
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            String pagedSql = this.addOffsetLimit(this.getCurrentDBType(), sql, this.startRecord, this.maxRecords);
            stmt = this.getConnection().prepareStatement(pagedSql, 1004, 1007);
            this.setParameters(stmt, params);
            stmt.setFetchSize(fetchSize);
            rs = stmt.executeQuery();
            ResultSet nonMovingRs = ResultSetProxyGenerator.nonMoving(rs);
            while (resultList.size() < this.maxRecords && rs.next()) {
                Q p = reader.restore(nonMovingRs);
                resultList.add(p);
            }
            if (!(rs.next() || resultList.isEmpty() && this.startRecord != 0L)) {
                result.setTotalRecords(this.startRecord + (long)resultList.size());
            }
            this.close(rs, stmt);
            if (this.forceTotalCount && result.getTotalRecords() < 0L) {
                String countSql = this.getCountSql(this.getCurrentDBType(), sql);
                ResultSet countRs = null;
                PreparedStatement countStmt = this.getConnection().prepareStatement(countSql, 1004, 1007);
                try {
                    this.setParameters(countStmt, params);
                    countRs = countStmt.executeQuery();
                    countRs.next();
                    result.setTotalRecords(countRs.getLong(1));
                    this.close(countRs, countStmt);
                }
                catch (Throwable throwable) {
                    this.close(countRs, countStmt);
                    throw throwable;
                }
            }
            result.setResults(resultList);
            this.close(rs, stmt);
        }
        catch (SQLException e) {
            try {
                SQLException ex = new SQLException("Error restoring objects : " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            catch (Throwable throwable) {
                this.close(rs, stmt);
                throw throwable;
            }
        }
        return result;
    }

    protected abstract void setParameters(PreparedStatement var1, List<Object> var2) throws SQLException;

    protected void close(ResultSet rs, PreparedStatement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                log.warn("Unable to close result set: " + e.getMessage(), e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.warn("Unable to close stmt: " + e.getMessage(), e);
            }
        }
    }

    public static enum DBTYPE {
        DERBY("Apache Derby"),
        MYSQL("MySQL"),
        ORACLE("Oracle"),
        ORACLE_11G(null),
        POSTGRES("PostgreSQL"),
        SQLSERVER("Microsoft SQL Server"),
        SQLSERVER_2008(null);

        String productName;

        public static DBTYPE getType(String name) {
            return DBTYPE.valueOf(name.toUpperCase(Locale.US));
        }

        public static DBTYPE getByProductName(String productName, int majorVersion) {
            DBTYPE result = null;
            for (DBTYPE type : DBTYPE.values()) {
                if (!productName.equalsIgnoreCase(type.productName)) continue;
                result = type;
            }
            if (result == null) {
                throw new IllegalArgumentException("Unknown product name " + productName);
            }
            if (result == SQLSERVER) {
                boolean is2008;
                boolean bl = is2008 = majorVersion < 11;
                if (is2008) {
                    result = SQLSERVER_2008;
                }
            } else if (result == ORACLE) {
                boolean isBefore12;
                boolean bl = isBefore12 = majorVersion < 12;
                if (isBefore12) {
                    result = ORACLE_11G;
                }
            }
            return result;
        }

        private DBTYPE(String productName) {
            this.productName = productName;
        }
    }
}

