/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.proxy;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.proxy.ProxyResponse;
import com.urbancode.commons.web.proxy.ProxyResponseHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;

class ProxyResponseFactory {
    public ProxyResponse fromCloseableHttpResponse(CloseableHttpResponse proxyHttpResponse) throws IOException {
        ProxyResponse proxyResponse = new ProxyResponse();
        StatusLine statusLine = proxyHttpResponse.getStatusLine();
        HttpEntity responseEntity = proxyHttpResponse.getEntity();
        proxyResponse.setStatusCode(statusLine.getStatusCode());
        proxyResponse.setStatusReason(statusLine.getReasonPhrase());
        ArrayList<ProxyResponseHeader> headers = new ArrayList<ProxyResponseHeader>();
        for (Header header : proxyHttpResponse.getAllHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            headers.add(new ProxyResponseHeader(headerName, headerValue));
        }
        proxyResponse.setHeaders(headers);
        if (responseEntity != null) {
            proxyResponse.setEntity(responseEntity.getContent());
        }
        return proxyResponse;
    }

    public ProxyResponse fromFile(final File file) throws IOException {
        file.setLastModified(System.currentTimeMillis());
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream dis = new ObjectInputStream(fis);
        ProxyResponse result = new ProxyResponse();
        result.setStatusCode(dis.readInt());
        result.setStatusReason(dis.readUTF());
        try {
            List headers = (List)dis.readObject();
            result.setHeaders(headers);
        }
        catch (ClassNotFoundException cnfe) {
            IO.closeNoThrow(dis);
            IOException wrapped = (IOException)new IOException(cnfe.toString()).initCause(cnfe);
            throw wrapped;
        }
        result.setEntity(new FilterInputStream(dis){

            public void close() throws IOException {
                file.setLastModified(System.currentTimeMillis());
                super.close();
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(ProxyResponse proxyResponse, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream dos = new ObjectOutputStream(fos);
        try {
            dos.writeInt(proxyResponse.getStatusCode());
            dos.writeUTF(proxyResponse.getStatusReason());
            dos.writeObject(proxyResponse.getHeaders());
            IO.copy(proxyResponse.getEntity(), (OutputStream)dos);
        }
        finally {
            proxyResponse.close();
            dos.close();
        }
    }
}

