/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.vfs.common.Hash;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.apache.http.entity.AbstractHttpEntity;

class FileEntity
extends AbstractHttpEntity {
    private String path;
    private File file;

    FileEntity(String path, File file) {
        Check.nonNull(path, "path");
        Check.nonNull(file, "file");
        this.path = path;
        this.file = file;
        this.setContentType("application/octet-stream");
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (GeneralSecurityException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out, 65536));
        dataOut.writeUTF(this.path);
        dataOut.writeLong(this.file.length());
        IO.copyAndDigest(this.file, (OutputStream)dataOut, digest);
        Hash hash = Hash.hashForMessageDigest(digest);
        dataOut.writeUTF(hash.toString());
        dataOut.flush();
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("getContent not implemented on FileEntity");
    }

    @Override
    public boolean isStreaming() {
        return false;
    }
}

