/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.kubernetes.KubernetesHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()
String url       = inProps['url']
String username  = inProps['username']
String password  = inProps['password']
String namespace = inProps['namespace']
String path      = inProps['path']
String globals   = inProps['globals']
String flags     = inProps['flags']
String image     = inProps['image']
String deploymentName = inProps['deploymentName'].trim()

// Set up helper
File workDir = new File(".").canonicalFile
KubernetesHelper kh = new KubernetesHelper(workDir, path)

// Step specific commands
ArrayList args = []
kh.setGlobals(args, url, username, password, namespace, globals)
args << 'run'
if (deploymentName.length() > 0) {
    args << deploymentName
}
else {
    args << image
}
args << '--image=' + image
kh.setFlags(args, flags)
if (kh.runCommand('[action]  Running image...', args, 'Image running.', 'Could not run image.')) {
    System.exit(0)
}
else {
    System.exit(1)
}