/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
 import com.urbancode.air.AirPluginTool
 import com.urbancode.air.plugin.kubernetes.KubernetesHelper

 // Get step properties
 AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
 Properties inProps   = apTool.getStepProperties()
 String release       = inProps['release']?.trim();
 String chart         = inProps['chart']?.trim();
 String flags         = inProps['flags']?.trim();
 String path          = inProps['path'].trim();
 String kubeconfig    = inProps['kubeconfig'].trim();

 // Set up helper
 if (!path) {
   path = "helm"
 }
 File workDir = new File(".").canonicalFile
 KubernetesHelper kh = new KubernetesHelper(workDir, path)
 if (kubeconfig) {
   kh.addEnvironmentVariable("KUBECONFIG", kubeconfig);
 }

 // Step specific commands
 ArrayList args = []
 args << 'upgrade'
 args << release
 args << chart
 kh.setFlags(args, flags)
 if (kh.runCommand('[action] Upgrading release ' + release + ' to chart ' + chart, args, 'Release ' + release + ' upgraded to chart ' + chart, 'Could not upgrade release ' + release + ' to chart ' + chart)) {
     System.exit(0)
 }
 else {
     System.exit(1)
 }