/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto;

import com.urbancode.commons.util.crypto.SecureRandomHelper;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import com.urbancode.commons.util.crypto.algs.DESAlg;
import com.urbancode.commons.util.crypto.algs.PBEAlg;
import com.urbancode.commons.util.crypto.algs.PlainAlg;
import com.urbancode.commons.util.crypto.algs.hash.NeverHash;
import com.urbancode.commons.util.crypto.algs.hash.PBKDF2WithHmacSHA1Alg;
import com.urbancode.commons.util.crypto.algs.hash.SHA256Alg;
import com.urbancode.commons.util.crypto.algs.hash.SHA512Alg;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AlgRegistry {
    public static CryptStringAlgorithm PBE_ALG = new PBEAlg();
    public static CryptStringAlgorithm DES_ALG = new DESAlg();
    public static CryptStringAlgorithm PLAIN_ALG = new PlainAlg();
    private static CryptStringAlgorithm SHA512_ALG = new SHA512Alg();
    private static CryptStringAlgorithm SHA256_ALG = new SHA256Alg();
    private static CryptStringAlgorithm PBKDF2_ALG = new PBKDF2WithHmacSHA1Alg();
    private static CryptStringAlgorithm[] ALGS = new CryptStringAlgorithm[]{PBE_ALG, DES_ALG, PLAIN_ALG, PBKDF2_ALG, SHA512_ALG, SHA256_ALG, new NeverHash()};
    private CryptStringAlgorithm DEFAULT_CRYPT_ALG = null;
    private CryptStringAlgorithm DEFAULT_HASH_ALG = null;
    private final ConcurrentMap<String, CryptStringAlgorithm> prefix2AlgLookup = new ConcurrentHashMap<String, CryptStringAlgorithm>();
    private final SecureRandom secureRandom = SecureRandomHelper.getSecureRandom();

    public AlgRegistry() {
        for (CryptStringAlgorithm alg : ALGS) {
            if (alg.getSecureRandom() != null) continue;
            alg.setSecureRandom(this.secureRandom);
        }
        for (CryptStringAlgorithm alg : ALGS) {
            if (!alg.isDecodeSupported() || !alg.isSupported()) continue;
            this.DEFAULT_CRYPT_ALG = alg;
            break;
        }
        if (this.DEFAULT_CRYPT_ALG == null) {
            throw new IllegalStateException("Could not find any supported encryption algorithms");
        }
        for (CryptStringAlgorithm alg : ALGS) {
            if (alg.isDecodeSupported() || !alg.isSupported()) continue;
            this.DEFAULT_HASH_ALG = alg;
            break;
        }
        if (this.DEFAULT_HASH_ALG == null) {
            throw new IllegalStateException("Could not find any supported hash algorithms");
        }
        for (CryptStringAlgorithm alg : ALGS) {
            this.prefix2AlgLookup.put(alg.getAlgPrefix(), alg);
        }
    }

    public CryptStringAlgorithm getDefaultHash() {
        return this.DEFAULT_HASH_ALG;
    }

    public CryptStringAlgorithm getDefaultCrypt() {
        return this.DEFAULT_CRYPT_ALG;
    }

    public SecureRandom getDefaultSecureRandom() {
        return this.secureRandom;
    }

    public void addCryptStringAlgorithm(CryptStringAlgorithm alg) {
        CryptStringAlgorithm oldAlg;
        if (alg.getSecureRandom() == null) {
            alg.setSecureRandom(this.getDefaultSecureRandom());
        }
        if ((oldAlg = this.prefix2AlgLookup.put(alg.getAlgPrefix(), alg)) != null) {
            // empty if block
        }
    }

    public CryptStringAlgorithm getAlg(String prefix) {
        return (CryptStringAlgorithm)this.prefix2AlgLookup.get(prefix);
    }

    public Set<String> getAlogrithmPrefixes() {
        return Collections.unmodifiableSet(new HashSet(this.prefix2AlgLookup.keySet()));
    }

    public Set<CryptStringAlgorithm> getAlogrithms() {
        return Collections.unmodifiableSet(new HashSet(this.prefix2AlgLookup.values()));
    }
}

