/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2020. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugin.kubernetes

import com.urbancode.air.CommandHelper
import com.urbancode.air.ExitCodeException
import java.util.regex.Matcher
import java.util.regex.Pattern
import groovy.json.JsonException
import groovy.json.JsonSlurper

class HelmHelper {
    public static def getHelmMajorVersion(KubernetesHelper kh) {
        ArrayList versionArgs = ['version'];
        String versionBuildInfo = kh.getOutputFromCommand('[action] Getting Helm version', versionArgs, 'Command completed without error and the output is:', 'Could not get Helm version');
        String version = versionBuildInfo.find(/:"v\d+\.\d+\.\d+/).find(/\d+\.\d+\.\d+/);
        return version[0];
    }
}