/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.kubernetes.KubernetesHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()
String url       = inProps['url'].trim()
String username  = inProps['username']?.trim()
String password  = inProps['password']?.trim()
String namespace = inProps['namespace'].trim()
String path      = inProps['path'].trim()
String globals   = inProps['globals'].trim()
String flags     = inProps['flags'].trim()
String type      = inProps['type'].trim()
String resources = inProps['resources'].trim()

// Set up helper
File workDir = new File(".").canonicalFile
KubernetesHelper kh = new KubernetesHelper(workDir, path)

// Step specific commands
ArrayList args = []
kh.setGlobals(args, url, username, password, namespace, globals)
args << 'delete'
if (type.equals('filename')) {
    args << '-f'
    resources.split('\\s+').each() { resource ->
        if (resource) {
            args << resource
        }
    }
}
else if (type.equals('names')) {
    resources.split('\\s+').each() { resource ->
        if (resource) {
            args << resource
        }
    }
}
else if (type.equals('labels')) {
    resArray = resources.split('\\s+')
    args << resArray[0]
    args << '-l'
    args << resArray[1]
}
else if (type.equals('all')) {
    resources.split('\\s+').each() { resource ->
        if (resource) {
            args << resource
        }
    }
    args << '--all'
}
kh.setFlags(args, flags)
if (kh.runCommand('[action]  Deleting resource...', args, 'Deleted resource.', 'Could not delete resource.')) {
    System.exit(0)
}
else {
    System.exit(1)
}