/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
 import com.urbancode.air.AirPluginTool
 import com.urbancode.air.plugin.kubernetes.KubernetesHelper
 
 // Get step properties
 AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
 Properties inProps = apTool.getStepProperties()
 String url       = inProps['url'].trim()
 String username  = inProps['username']?.trim()
 String password  = inProps['password']?.trim()
 String namespace = inProps['namespace'].trim()
 String path      = inProps['path'].trim()
 String globals   = inProps['globals'].trim()
 String flags     = inProps['flags'].trim()
 String cluster   = inProps['clustername'].trim()

 // Set up helper
 File workDir = new File(".").canonicalFile
 KubernetesHelper kh = new KubernetesHelper(workDir, path)
 
 // Step specific commands
 ArrayList args = []
 kh.setGlobals(args, url, username, password, namespace, globals)
 args << 'config'
 args << 'set-cluster'
 args << cluster
 kh.setFlags(args, flags)
 if (kh.runCommand('[action]  Setting a cluster entry in kubeconfig...', args, 'Cluster entry set in kubeconfig.', 'Could not set a cluster entry in kubeconfig.')) {
     System.exit(0)
 }
 else {
     System.exit(1)
 }