/**
 * (c) Copyright IBM Corporation 2013, 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.mulesoft.MuleRestClient

File workDir = new File('.')

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties(System.getenv("UCD_SECRET_VAR"))
def helper = new MuleRestClient(props)


try {
        println(helper.getTimestamp() + "Deploying application");

        helper.deployAppOnCloudHub();

        println(helper.getTimestamp() +  "App was successfully deployed to cloudhub. ")
}
catch (Exception e) {
    e.printStackTrace();
    throw e;
}
finally {
    apTool.setOutputProperties(System.getenv("UCD_SECRET_VAR"))
    helper.cleanUp();
}