/**
 * (c) Copyright IBM Corporation 2016, 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.air.plugin.mulesoft;

import groovy.json.JsonSlurper
import java.text.SimpleDateFormat
import java.util.Properties
import org.apache.http.HttpResponse
import org.apache.http.HttpStatus
import org.apache.http.util.EntityUtils
import org.apache.log4j.Logger
import org.codehaus.jettison.json.JSONArray
import org.codehaus.jettison.json.JSONObject

class MuleRestClient {

    private RestClientHelper restHelper
    private Logger logger

	private String username
	private String password
	private String accessToken
	private String orgId
	private String envId
	private String appPath
	private String appName
    

    public MuleRestClient(Properties props) {

        // Local fields
		this.username = props['username'].toString().trim()
		this.password = props['password'].toString().trim()
		this.appPath = props['apppath'].toString().trim()
		this.appName = props['appname'].toString().trim()


        logger = Logger.getLogger(getClass())

    }

    public void deployAppOnCloudHub() {
    
		Date startTime = new Date()
		
		getToken()
		getOrgId()
		getEnvId()

		
		try {

			restHelper.addRequestHeader("Content-Type", "multipart/form-data")
			restHelper.addRequestHeader("Authorization", "Bearer " + accessToken)
			restHelper.addRequestHeader("X-ANYPNT-ENV-ID", envId)
			
			
			String Body = "file:" +  appPath +","      
             + "autoStart:" + true    +","                  
            + "appInfoJson:{"  
              +   "domain: " + appName + ","
                + "muleVersion:" + {"version:" + "4.2.2"}+ ","
                + "region :" + "us-east-1" + ","
                + "monitoringEnabled :" + true + ","
                + "monitoringAutoRestart: "  + true + ","
                + "workers:"+ {"amount:" + (int)1 + "," + "type :" +  {"name:" + "Micro" + "," + "weight :" + "0.1" + "," + "cpu : " + "0.1 vCores" + "," +  "memory:" + "500 MB memory"}} + ","
               +  "loggingNgEnabled:" + true + ","
               +  "persistentQueues:" + false
			
			   HttpResponse response = restHelper.doPostRequest("https://anypoint.mulesoft.com/cloudhub/api/v2/applications", Body)
		
			if (!response) {
				println ("[Error] Could not deploy application - ${response}")
				throw new Exception()
			}
			if (!response.getStatusLine().getStatusCode().equals(HttpStatus.SC_ACCEPTED)) {
				println ("[Error] Bad response code of ${response.getStatusLine().getStatusCode()} - ${response}.")
				println ('Response:\n' + response.entity?.content?.getText("UTF-8"))
				throw new Exception()
			}
		
		}catch (Exception ex) {
			ex.printStackTrace()
			throw ex
		}
		
		System.out.println("${getTimestamp()} Application deployed successfully.")
		
		
	}
	
	public void getToken() {

		try {
			
			restHelper.addRequestHeader("Content-Type", "application/json")
			
			String Body =  "{"
				+"username:" +  username  + "," 
				+ "password:" +  password
			  + "}"
			HttpResponse response = restHelper.doRequest("https://anypoint.mulesoft.com/accounts/login", Body)
			

			if (!response) {
				println ("[Error] Could not get token - ${response}")
				throw new Exception()
			}
			
			if (response.getStatusLine().getStatusCode().equals(HttpStatus.SC_OK) || response.getStatusLine().getStatusCode().equals(HttpStatus.SC_SERVICE_UNAVAILABLE)) {
				accessToken = restHelper.parseResponse(response)

			}
			
			if (response.getStatusLine().getStatusCode().equals(HttpStatus.SC_NOT_FOUND)) {
				throw new Exception()
			}
			
			
			println ("[Error] Bad response code of ${response.getStatusLine().getStatusCode()} - ${response}.")
			println ('Response:\n' + response.entity?.content?.getText("UTF-8"))
			throw new Exception()


		}catch (Exception ex) {
			ex.printStackTrace()
			throw ex
		}
		
	}
	
	public void getOrgId() {
		
			try {
				restHelper.addRequestHeader("Authorization", "Bearer " + accessToken)
				HttpResponse response = restHelper.doGetRequest("https://anypoint.mulesoft.com/accounts/api/me")
					
		
				if (!response) {
					println ("[Error] Could not org id - ${response}")
					throw new Exception()
				}
					
				if (response.getStatusLine().getStatusCode().equals(HttpStatus.SC_OK) || response.getStatusLine().getStatusCode().equals(HttpStatus.SC_SERVICE_UNAVAILABLE)) {
					orgId = restHelper.parseResponse(response).user.organization.id
		
				}
					
				if (response.getStatusLine().getStatusCode().equals(HttpStatus.SC_NOT_FOUND)) {
					throw new Exception()
				}
					
				
				println ("[Error] Bad response code of ${response.getStatusLine().getStatusCode()} - ${response}.")
				println ('Response:\n' + response.entity?.content?.getText("UTF-8"))
				throw new Exception()
		
		
			}catch (Exception ex) {
			ex.printStackTrace()
				throw ex
			}
			
		}

	public void getEnvId() {
		
			try {
				restHelper.addRequestHeader("Authorization", "Bearer " + accessToken)
				HttpResponse response = restHelper.doGetRequest("https://anypoint.mulesoft.com/accounts/api/organizations/" + orgId + "/environments")
						
				
				if (!response) {
					println ("[Error] Could not org id - ${response}")
					throw new Exception()
				}
							
				if (response.getStatusLine().getStatusCode().equals(HttpStatus.SC_OK) || response.getStatusLine().getStatusCode().equals(HttpStatus.SC_SERVICE_UNAVAILABLE)) {
					envId = restHelper.parseResponse(response).data.id
		
				}
							
				if (response.getStatusLine().getStatusCode().equals(HttpStatus.SC_NOT_FOUND)) {
					throw new Exception()
				}
							
							
				println ("[Error] Bad response code of ${response.getStatusLine().getStatusCode()} - ${response}.")
				println ('Response:\n' + response.entity?.content?.getText("UTF-8"))
				throw new Exception()
				
				
				}catch (Exception ex) {
		     		ex.printStackTrace()
					throw ex
				}
				
	}
			
			
    public void cleanUp() {
        //TODO
        
    }
    
    
    public static String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("[MM/dd/yyyy HH:mm:ss]")

        return dateFormat.format(new Date())
    }

    /**
     * Encode HTML form parameters.
     * @param path
     * @return The encoded parameter.
     * @throws UnsupportedEncodingException
     */
    private String encodePath(String path) throws UnsupportedEncodingException {
        return URLEncoder.encode(path, "UTF-8");
    }

    
}
