/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.NexusClient;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusClientMaven
extends NexusClient {
    String group;
    String artifact;
    final XPath xpath;
    private Map<String, File> tempDirs = new HashMap<String, File>();

    public NexusClientMaven(String serverUrl, String username, String password, String repo, String group, String artifact) {
        super(serverUrl, username, password, repo);
        this.group = group.replaceAll("\\.", "/").trim();
        this.artifact = artifact.trim();
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    public File downloadFiles(String version) throws IOException, SAXException {
        List<String> uris = this.getResourceURIsFromVersion(version);
        System.out.println("Downloading...");
        for (String uri : uris) {
            this.download(version, uri);
        }
        return this.getTempDir(version);
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(System.getProperty("user.dir"), UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    public List<String> getLatestVersions(String versionNamePattern) throws IOException, SAXException {
        ArrayList<String> result = new ArrayList();
        List<String> versionList = this.getVersionList();
        if (versionNamePattern == null || versionNamePattern.trim().isEmpty()) {
            versionNamePattern = ".*";
        }
        result = this.getMatchingVersionNames(versionList, versionNamePattern);
        return result;
    }

    public List<String> getVersionList() throws IOException, SAXException {
        ArrayList<String> versions = new ArrayList();
        String path = this.serverUrl + "/" + this.ROOT_PATH + this.group + "/" + this.artifact + "/maven-metadata.xml";
        System.out.println("[Info] maven-metadata.xml URL: " + path);
        HttpGet getRequest = new HttpGet(path);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)getRequest);
            HttpEntity entity = response.getEntity();
            String xml = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            Document responseDoc = this.changeXmlToDocument(xml);
            if (!this.getArtifactIdFromXml(responseDoc).equals(this.artifact)) {
                System.out.println("[Warning] Unable to view the maven-metadata.xml's contents. Confirm the maven-metadata.xml and Nexus Respository URLs.");
            }
            versions = this.getVersionsFromXml(responseDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Fail");
        }
        finally {
            response.close();
        }
        return versions;
    }

    public List<String> getAllSnapshotVersions(String version) throws IOException, SAXException {
        HashSet<String> snapshotVersions = new HashSet<String>();
        List<String> snapshotUris = this.getResourceURIsFromVersion(version);
        String regex = this.artifact + "-(" + version.replaceAll("-SNAPSHOT", "") + "-" + "\\d+\\.\\d+-\\d+)\\..*";
        for (String snapshotUri : snapshotUris) {
            String name = this.getFileName(snapshotUri);
            if (name.contains("maven-metadata.xml")) continue;
            Pattern r = Pattern.compile(regex);
            Matcher m = r.matcher(name);
            if (m.find()) {
                if (m.group(1) == null || m.group(1).equals("")) {
                    System.out.println("[Error] Unable to identify version from '" + name + "'.");
                    continue;
                }
                snapshotVersions.add(m.group(1).replace(version.replaceAll("-SNAPSHOT", ""), version));
                continue;
            }
            System.out.println("[Error] Unable to identify '" + name + "'.");
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(snapshotVersions);
        return result;
    }

    private List<String> getResourceURIsFromVersion(String version) throws IOException, SAXException {
        String path = this.serverUrl + "/" + this.ROOT_PATH + this.group + "/" + this.artifact + "/" + version;
        HttpGet getRequest = new HttpGet(path);
        CloseableHttpResponse response = null;
        ArrayList<String> result = new ArrayList();
        try {
            response = this.client.execute((HttpUriRequest)getRequest);
            HttpEntity entity = response.getEntity();
            String xml = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            Document responseDoc = this.changeXmlToDocument(xml);
            result = this.getResourceURIsFromXml(responseDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Fail");
        }
        finally {
            response.close();
        }
        return result;
    }

    private List<String> getResourceURIsFromXml(Document doc) throws XPathExpressionException {
        XPathExpression allResourceURIsExpression = this.getAllResourceURIsExpression();
        NodeList nodeList = (NodeList)allResourceURIsExpression.evaluate(doc, XPathConstants.NODESET);
        ArrayList<String> uriList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String uri = nodeList.item(i).getTextContent().trim();
            uriList.add(uri);
        }
        Collections.reverse(uriList);
        return uriList;
    }

    private String getArtifactIdFromXml(Document doc) throws XPathExpressionException {
        String artifactId = "";
        XPathExpression artifactIdExpression = this.getArtifactIdExpression();
        artifactId = artifactIdExpression.evaluate(doc);
        return artifactId;
    }

    private List<String> getVersionsFromXml(Document doc) throws XPathExpressionException {
        XPathExpression allVersionsExpression = this.getAllVersionsExpression();
        NodeList nodeList = (NodeList)allVersionsExpression.evaluate(doc, XPathConstants.NODESET);
        ArrayList<String> versionList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String version = nodeList.item(i).getTextContent().trim();
            versionList.add(version);
        }
        Collections.reverse(versionList);
        return versionList;
    }

    private List<String> getMatchingVersionNames(List<String> versionList, String versionNamePattern) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, Integer> group2Version = new HashMap<String, Integer>();
        Pattern regex = Pattern.compile(versionNamePattern);
        for (String version : versionList) {
            Matcher matcher = regex.matcher(version);
            if (matcher.matches()) {
                String group = null;
                try {
                    group = matcher.group(1);
                }
                catch (Exception e) {
                    group = "default";
                }
                Integer groupCount = (Integer)group2Version.get(group);
                if (groupCount == null) {
                    groupCount = 0;
                    System.out.println("Found group, '" + group + "'");
                }
                result.add(version);
                groupCount = groupCount + 1;
                group2Version.put(group, groupCount);
                System.out.println("[Action] Adding version: '" + version + "' from group: '" + group + "' (" + groupCount + ")");
                continue;
            }
            System.out.println("[Info] Version '" + version + "' does not match pattern, '" + versionNamePattern);
        }
        return result;
    }

    public boolean containsRevision(String revision) throws IOException, SAXException {
        List<String> versionList = this.getVersionList();
        boolean result = versionList.contains(revision);
        if (!result) {
            System.out.println("[Info] Could not find specific revision, '" + revision + "' on " + this.getMavenMetadataXmlPath());
        }
        return result;
    }

    private String getFileName(String url) throws IOException {
        int index = url.lastIndexOf(47);
        if (index == -1) {
            throw new IOException("Invalid URL");
        }
        String result = url.substring(index + 1);
        if (result.length() == 0) {
            throw new IOException("Invalid URL");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String version, String url) throws IOException {
        block4: {
            HttpGet method = new HttpGet(url);
            System.out.println("[Action] Downloading file from " + url + "...");
            CloseableHttpResponse response = null;
            try {
                response = this.client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    File file = new File(this.getTempDir(version), this.getFileName(url));
                    IO.copy(response.getEntity().getContent(), file);
                    System.out.println("[Info] Downloaded " + file.getAbsolutePath());
                    break block4;
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
            finally {
                response.close();
            }
        }
    }

    private String getMavenMetadataXmlPath() {
        String group = this.group.replace('.', '/');
        return String.format("%s/%s/%s/maven-metadata.xml", this.repo, group, this.artifact);
    }

    private XPathExpression getAllResourceURIsExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile("/content/data/content-item/resourceURI");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getAllVersionsExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile("/metadata/versioning/versions/version");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getArtifactIdExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile("/metadata/artifactId");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

