/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.air.plugin.command.NexusClient;
import com.urbancode.air.plugin.command.NexusClientMaven;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int result;
        block24: {
            result = 0;
            NexusClient nexusClient = null;
            try {
                Properties agentProps = new Properties();
                agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                String serverUrl = this.inputProperties.getProperty("serverUrl");
                String nexusUsername = this.inputProperties.getProperty("user");
                String nexusPassword = this.inputProperties.getProperty("password");
                String repo = this.inputProperties.getProperty("repo");
                String group = this.inputProperties.getProperty("group");
                String artifact = this.inputProperties.getProperty("artifact");
                String revision = this.inputProperties.getProperty("version");
                String charsetName = agentProps.getProperty("system.default.encoding");
                String componentName = this.inputProperties.getProperty("componentName");
                boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                String includesString = this.inputProperties.getProperty("includes");
                String[] includes = new String[]{};
                if (includesString != null) {
                    if (includesString.trim().length() == 0) {
                        includesString = "**/*";
                    }
                    includes = includesString.split(",|\n");
                    for (int i = 0; i < includes.length; ++i) {
                        includes[i] = includes[i].trim();
                    }
                }
                String excludesString = this.inputProperties.getProperty("excludes");
                String[] excludes = new String[]{};
                if (excludesString != null) {
                    excludes = excludesString.split(",|\n");
                    for (int i = 0; i < excludes.length; ++i) {
                        excludes[i] = excludes[i].trim();
                    }
                }
                String extensionString = this.inputProperties.getProperty("extensions");
                String[] extensions = new String[]{};
                if (extensionString != null) {
                    extensions = extensionString.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                }
                Charset charset = null;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                String username = "PasswordIsAuthToken";
                String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                String webUrl = System.getenv("AH_WEB_URL");
                URI ucdUrl = new URI(webUrl);
                nexusClient = new NexusClientMaven(serverUrl, nexusUsername, nexusPassword, repo, group, artifact);
                VersionClient versionClient = new VersionClient(ucdUrl, username, password);
                ComponentClient componentClient = new ComponentClient(ucdUrl, username, password);
                if (revision != null && revision.trim().length() > 0) {
                    if (((NexusClientMaven)nexusClient).containsRevision(revision)) {
                        try {
                            if (!this.integrate((NexusClientMaven)nexusClient, componentClient, versionClient, componentName, revision, isUseVFS, charset, extensions, includes, excludes)) {
                                System.out.println("[Info] This component already contains version '" + revision + "'. Duplicate(s) will not be created.");
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            throw new PluginExecutionException(String.format("Integration failure", new Object[0]));
                        }
                    }
                    throw new PluginExecutionException(String.format("Maven does not contain the version '%s'", revision));
                }
                List<String> versions = ((NexusClientMaven)nexusClient).getVersionList();
                int importCount = 0;
                for (String version : versions) {
                    try {
                        if (!this.integrate((NexusClientMaven)nexusClient, componentClient, versionClient, componentName, version, isUseVFS, charset, extensions, includes, excludes)) continue;
                        ++importCount;
                    }
                    catch (Exception e) {
                        throw new PluginExecutionException(String.format("Integration failure", new Object[0]));
                    }
                }
                if (versions.size() < 1) {
                    System.out.println("Did not find any versions in the Nexus Maven Repository.");
                } else if (importCount == 0) {
                    System.out.println("[Info] This component already contains all versions. Duplicate(s) will not be created.");
                }
            }
            catch (Exception e) {
                System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
                e.printStackTrace();
                result = 1;
            }
            finally {
                nexusClient.closeClient();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean integrate(NexusClientMaven maven, ComponentClient componentClient, VersionClient versionClient, String componentName, String mavenVersion, boolean isUseVFS, Charset charset, String[] extensions, String[] includes, String[] excludes) throws Exception {
        boolean result;
        File tempDir;
        block16: {
            tempDir = null;
            result = false;
            try {
                boolean preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                List<Object> importVersions = new ArrayList<String>();
                if (mavenVersion.contains("SNAPSHOT")) {
                    importVersions = maven.getAllSnapshotVersions(mavenVersion);
                } else {
                    importVersions.add(mavenVersion);
                }
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                List archivedVersions = componentClient.getArchivedComponentVersions(componentName);
                versions.addAll(archivedVersions);
                importVersions.removeAll(versions);
                ArrayList<Object> allVersions = new ArrayList<Object>(versions);
                allVersions.addAll(importVersions);
                if (importVersions.size() <= 0) break block16;
                System.out.println("New version(s) from Nexus Maven: " + importVersions.toString());
                if (isUseVFS) {
                    System.out.println("Creating new version(s): " + importVersions.toString() + " and uploading files to VFS");
                    tempDir = maven.downloadFiles(mavenVersion);
                    ArrayList<Object> importVersionsWithSnapshot = new ArrayList<Object>(importVersions);
                    if (mavenVersion.contains("SNAPSHOT")) {
                        for (String string : allVersions) {
                            importVersionsWithSnapshot.add("*" + string.replace("-SNAPSHOT", "") + "*");
                        }
                        importVersionsWithSnapshot.add("maven-metadata.xml*");
                    }
                    for (String string : importVersions) {
                        ArrayList<Object> snapshotExcludes = new ArrayList<Object>(importVersionsWithSnapshot);
                        snapshotExcludes.remove("*" + string.replace("-SNAPSHOT", "") + "*");
                        String[] fullExcludes = (String[])ArrayUtils.addAll((Object[])excludes, (Object[])snapshotExcludes.toArray(new String[0]));
                        String versionId = versionClient.createAndAddVersionFiles(componentName, string, "", tempDir, "", includes, fullExcludes, preserveExecutePermissions, true, charset, extensions).toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                    }
                } else {
                    System.out.println("Creating new version(s)");
                    for (String string : importVersions) {
                        String string2 = versionClient.createVersion(componentName, string, " ", true).toString();
                        versionClient.markImportFinished(componentName, string2);
                        this.outputProperties.setProperty("VersionID", string2);
                    }
                    System.out.println("Not uploading version(s) " + importVersions.toString() + " to VFS because using VFS was not selected.");
                }
                result = true;
            }
            catch (Throwable throwable) {
                try {
                    if (tempDir != null && tempDir.exists()) {
                        IO.delete(tempDir);
                    }
                }
                catch (IOException e) {
                    System.err.println(String.format("[Error] Unable to delete download directory", e.getMessage()));
                }
                throw throwable;
            }
        }
        try {
            if (tempDir != null && tempDir.exists()) {
                IO.delete(tempDir);
            }
        }
        catch (IOException e) {
            System.err.println(String.format("[Error] Unable to delete download directory", e.getMessage()));
        }
        return result;
    }
}

