/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NexusClient {
    public String serverUrl;
    public String username;
    public String password;
    public String repo;
    public int nexusVersion;
    final String ROOT_PATH;
    public CloseableHttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NexusClient(String serverUrl, String username, String password, String repo) {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.serverUrl = serverUrl;
        this.username = username;
        this.password = password;
        this.repo = repo;
        this.client = this.getHttpClient();
        try {
            this.nexusVersion = this.getNexusVersion();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (this.nexusVersion != 2) {
                if (this.nexusVersion == 3) {
                    throw new RuntimeException("[Error] The Nexus Source Config plug-in does not support Nexus versions 3 and greater. Please use the Maven Source Config plug-in.");
                }
                throw new RuntimeException("[Error] Server version could not be identified. Confirm the supplied server URL is valid.");
            }
            this.ROOT_PATH = "service/local/repositories/" + repo + "/content/";
        }
    }

    private CloseableHttpClient getHttpClient() {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty((CharSequence)this.username)) {
            builder.setUsername(this.username);
            builder.setPassword(this.password);
            builder.setPreemptiveAuthentication(true);
        }
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    public void closeClient() {
        if (this.client != null) {
            ClientConnectionManager connectionManager = this.client.getConnectionManager();
            connectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
            connectionManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNexusVersion() throws IOException {
        int statusCode;
        HttpGet getRequest;
        int result = -1;
        CloseableHttpResponse response = null;
        try {
            String v2Path = this.serverUrl + "/service/local/repositories";
            getRequest = new HttpGet(v2Path);
            response = this.client.execute((HttpUriRequest)getRequest);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                System.out.println("[Info] Identified Nexus v2.");
                result = 2;
            }
        }
        catch (Exception v2Path) {
        }
        finally {
            response.close();
        }
        if (result == -1) {
            response = null;
            try {
                String v3Path = this.serverUrl + "/service/siesta/rest/v1/script/";
                getRequest = new HttpGet(v3Path);
                response = this.client.execute((HttpUriRequest)getRequest);
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    System.out.println("[Info] Identified Nexus v3.");
                    result = 3;
                }
            }
            catch (Exception exception) {
            }
            finally {
                response.close();
            }
        }
        return result;
    }

    public Document changeXmlToDocument(String xml) throws IOException, SAXException {
        Document doc;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new RuntimeException("[Error] Could not parse XML.");
        }
        return doc;
    }
}

