/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.unix;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.environment.Environment;
import com.urbancode.commons.util.processes.ProcessException;
import com.urbancode.commons.util.processes.Processes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
abstract class Command<T> {
    private static final Logger log = Logger.getLogger(Command.class);
    private final OutputMode outputMode;
    private final Processes processes;
    private final Environment environment;

    protected Command(OutputMode outputMode) {
        this(outputMode, new Processes(), Environment.getGlobalInstance());
    }

    @Deprecated
    protected Command(OutputMode outputMode, Processes processes) {
        this(outputMode, processes, Environment.getGlobalInstance());
    }

    protected Command(OutputMode outputMode, Processes processes, Environment environment) {
        this.outputMode = Check.nonNull(outputMode, "outputMode");
        this.processes = Check.nonNull(processes, "processes");
        this.environment = Check.nonNull(environment, "environment");
    }

    protected abstract void buildCommand(List<String> var1) throws IOException;

    protected T processOutput(String output) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected T processOutput(InputStream output) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final T execute() throws IOException {
        T result = null;
        ArrayList<String> command = new ArrayList<String>();
        this.buildCommand(command);
        ProcessBuilder builder = new ProcessBuilder(command);
        this.environment.copyTo(builder.environment());
        builder.environment().put("LC_ALL", "C");
        if (log.isDebugEnabled()) {
            log.debug("Executing " + command);
        }
        Process process = builder.start();
        try {
            process.getOutputStream().close();
            Future<String> errorFuture = this.processes.getErrorStringFuture(process);
            try {
                switch (this.outputMode) {
                    case STREAM: {
                        result = this.processOutput(process.getInputStream());
                        break;
                    }
                    case STRING: {
                        result = this.processOutput(this.processes.getOutputString(process));
                        break;
                    }
                    case DISCARD: {
                        this.processes.discardOutput(process);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    try {
                        String error = errorFuture.get().trim();
                        throw new ProcessException(exitCode, error);
                    }
                    catch (ExecutionException e) {
                        throw new ProcessException(exitCode, (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
            }
        }
        finally {
            process.destroy();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static enum OutputMode {
        STREAM,
        STRING,
        DISCARD;

    }
}

