/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web;

import com.urbancode.commons.web.authentication.AbstractCookieAuthenticator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebConfig {
    private static WebConfig instance;
    private String taskPackagePrefix;
    private String loginFormTaskMethod;
    private String loginTaskMethod;
    private String logoutTaskMethod;
    private List<String> publicAreaPatterns = new ArrayList<String>();
    private List<String> secureAreaPatterns = new ArrayList<String>();
    private String passwordRecoveryTaskMethod;
    private AbstractCookieAuthenticator cookieAuthenticator;
    private String rawLoginCookieKey;
    private String exceptionView = "/WEB-INF/snippets/errors/exception.jsp";
    private Map<Integer, Integer> forcedErrorCodes = new HashMap<Integer, Integer>();

    public static WebConfig getInstance() {
        if (instance == null) {
            instance = new WebConfig();
        }
        return instance;
    }

    private WebConfig() {
    }

    public String getTaskPackagePrefix() {
        if (this.taskPackagePrefix == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.taskPackagePrefix;
    }

    public void setTaskPackagePrefix(String taskPackagePrefix) {
        this.taskPackagePrefix = taskPackagePrefix;
    }

    public String getLoginFormTaskMethod() {
        if (this.loginFormTaskMethod == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.loginFormTaskMethod;
    }

    public void setLoginFormTaskMethod(String loginFormTaskMethod) {
        this.loginFormTaskMethod = loginFormTaskMethod;
    }

    public String getLoginTaskMethod() {
        if (this.loginTaskMethod == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.loginTaskMethod;
    }

    public void setLoginTaskMethod(String loginTaskMethod) {
        this.loginTaskMethod = loginTaskMethod;
    }

    public String getLogoutTaskMethod() {
        if (this.logoutTaskMethod == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.logoutTaskMethod;
    }

    public void setLogoutTaskMethod(String logoutTaskMethod) {
        this.logoutTaskMethod = logoutTaskMethod;
    }

    public String getPasswordRecoveryTaskMethod() {
        if (this.passwordRecoveryTaskMethod == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.passwordRecoveryTaskMethod;
    }

    public void setPasswordRecoveryTaskMethod(String passwordRecoveryTaskMethod) {
        this.passwordRecoveryTaskMethod = passwordRecoveryTaskMethod;
    }

    public AbstractCookieAuthenticator getCookieAuthenticator() {
        if (this.cookieAuthenticator == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.cookieAuthenticator;
    }

    public void setCookieAuthenticator(AbstractCookieAuthenticator cookieAuthenticator) {
        this.cookieAuthenticator = cookieAuthenticator;
    }

    public String getRawLoginCookieKey() {
        if (this.rawLoginCookieKey == null) {
            throw new RuntimeException("Configure the class before reading it.");
        }
        return this.rawLoginCookieKey;
    }

    public void setRawLoginCookieKey(String rawLoginCookieKey) {
        if (rawLoginCookieKey.length() != 16) {
            throw new IllegalArgumentException("Key length should be 16.");
        }
        this.rawLoginCookieKey = rawLoginCookieKey;
    }

    public void setPublicAreaPatterns(List<String> publicAreaPatterns) {
        this.publicAreaPatterns = publicAreaPatterns;
    }

    public List<String> getPublicAreaPatterns() {
        return this.publicAreaPatterns;
    }

    public void setSecureAreaPatterns(List<String> secureAreaPatterns) {
        this.secureAreaPatterns = secureAreaPatterns;
    }

    public List<String> getSecureAreaPatterns() {
        return this.secureAreaPatterns;
    }

    public void setExceptionView(String exceptionView) {
        this.exceptionView = exceptionView;
    }

    public String getExceptionView() {
        return this.exceptionView;
    }

    public Integer getForcedErrorCode(Integer originalCode) {
        return this.forcedErrorCodes.get(originalCode);
    }

    public void setForcedErrorCode(Integer originalErrorCode, Integer forcedErrorCode) {
        this.forcedErrorCodes.put(originalErrorCode, forcedErrorCode);
    }
}

