/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

package com.urbancode.plugins.nuget

public class NuGetVersion {

    String id
    String pkgTitle
    String title
    String updated
    String description
    String content
    String version

    String name // Not part of the NuGet entry, used for renamed imports

    // Retrieve renamed version, else use version as name
    public String getName() {
        String result = name
        if (!result) {
            result = version
        }
        return result
    }

    public String getFilename() {
        return (pkgTitle + "." + version + ".nupkg").toLowerCase()
    }

    // Used for debugging purposes
    public void prettyPrint() {
        println "============="
        println "id: " + id
        println "pkgTitle: " + pkgTitle
        println "title: " + title
        println "updated: " + updated
        println "description: " + description
        println "content: " + content
        println "version: " + version
        println "============="
    }
}
