/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.openshift.OpenShiftHelper

// Get step properties
def apTool   = new AirPluginTool(args[0], args[1])
def inProps  = apTool.getStepProperties()

String url          = inProps['url']?.trim()
String username     = inProps['username']
String password     = inProps['password']
String token        = inProps['token']
String insecure     = inProps['insecure']
String home         = inProps['home']?.trim()
String project      = inProps['project']?.trim()
String config       = inProps['config']?.trim()
String type         = inProps['type']
String flags        = inProps['flags']?.trim();

// Set up helper
File workDir = new File(".").canonicalFile
OpenShiftHelper osh = new OpenShiftHelper(workDir, home)
//osh.login(url, username, password, token, insecure.toBoolean())
//osh.setProject(project)

// Rollout
def args = []
args << 'rollout'
if (type.equals('cancel')) {
    args << 'cancel'
}
else if (type.equals('history')) {
    args << 'history'
}
else if (type.equals('latest')) {
    args << 'latest'
}
else if (type.equals('pause')) {
    args << 'pause'
}
else if (type.equals('resume')) {
    args << 'resume'
}
else if (type.equals('retry')) {
    args << 'retry'
}
else if (type.equals('status')) {
    args << 'status'
}
else if (type.equals('undo')) {
    args << 'undo'
}

args << config

osh.setFlags(args, flags)
osh.runCommand("[Action] Executing Rollout Operation...", args) { Process proc ->
    def (String sout, String serr) = osh.captureCommand(proc)
    if (serr) {
        println ('[Error] Rollout operation failed.')
        println (serr)
        println (sout)
        System.exit(1)
    }
    else {
        println ('[Ok] Rollout operation succeeded.')
        println (sout)
    }
}