/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.openshift.OpenShiftHelper

// Get step properties
def apTool   = new AirPluginTool(args[0], args[1])
def props  = apTool.getStepProperties()

String url          = props['url'].trim()
String username     = props['username']
String token        = props['token']
String insecure     = props['insecure']
String home         = props['home'].trim()
String project      = props['project'].trim()

String config       = props['config'].trim()
String patchJSON    = props['patchJSON'].trim()

if (!patchJSON.contains("\r") && !patchJSON.contains("\n")) {
    def patchJsonFile = new File(patchJSON)
    if (patchJsonFile.exists()){
        patchJSON = patchJsonFile.text
    }
}


// Set up helper
File workDir = new File(".").canonicalFile
OpenShiftHelper osh = new OpenShiftHelper(workDir, home)

// Deploy
def args = []
args << 'patch'

if (url) {
    args << '--server=' + url
}

if(project) {
    args << '--namespace=' + project
}

if (username) {
    args << '--user=' + username
}

if (token) {
    args << '--token=' + token
}

if (insecure.toBoolean()) {
    args << '--insecure-skip-tls-verify'
}

args << "dc/$config"
args << "-p"
args << patchJSON

osh.runCommand("[Action] Executing Patch Operation...", args) { Process proc ->
    def (String sout, String serr) = osh.captureCommand(proc)
    if (serr) {
        println ('[Error] Patch operation failed.')
        println (serr)
        println (sout)
        System.exit(1)
    }
    else {
        println ('[Ok] Patch operation succeeded.')
        println (sout)
    }
}