/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.openshift.OpenShiftHelper

// Get step properties
def apTool   = new AirPluginTool(args[0], args[1])
def inProps  = apTool.getStepProperties()

String url                = inProps['url']?.trim()
String username           = inProps['username']
String token              = inProps['token']
String insecure           = inProps['insecure']
String home               = inProps['home']?.trim()
String project            = inProps['project']?.trim()
String resourceAndObjects = inProps['resourceAndObjects']?.trim()
String resources          = inProps['resources']?.trim()
String containerAndImage  = inProps['containerAndImage']?.trim()
String path               = inProps['path']?.trim()
String flags              = inProps['flags']?.trim();

// Set up helper
File workDir = new File(".").canonicalFile
OpenShiftHelper osh = new OpenShiftHelper(workDir, home)

// Set Image
def args = []
args << 'set'
args << 'image'

if (url) {
    args << '--server=' + url
}

if(project) {
    args << '--namespace=' + project
}

if (username) {
    args << '--user=' + username
}

if (token) {
    args << '--token=' + token
}

if (insecure.toBoolean()) {
    args << '--insecure-skip-tls-verify'
}

if (resourceAndObjects) {
    resourceAndObjects.split("[\r\n]+").each() { resourceAndObject ->
        args << resourceAndObject
    }
}

if (resources) {
    args << resources
}

if (containerAndImage) {
    args << containerAndImage
}

if (path) {
    args << '-f'
    args << path
}

osh.setFlags(args, flags)
osh.runCommand("[Action] Executing set image Operation...", args) { Process proc ->
    def (String sout, String serr) = osh.captureCommand(proc)
    if (serr) {
        println ('[Error] Set image operation failed.')
        println (serr)
        println (sout)
        System.exit(1)
    }
    else {
        println ('[Ok] Set image operation succeeded.')
        println (sout)
    }
}