import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.optim.OptimHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
def failOnWarning = Boolean.valueOf(props['failOnWarning'])

def optimHelper = new OptimHelper(props)
optimHelper.handleInputOutput()
def exitCode = optimHelper.runCommand("Running convert request.", "CONVERT")

/*Exit Codes
 * 0: No Errors
 * 4: Informational message
 * 8: Warning message
 * 12: Fatal message
 * 16: Syntax error in command
 * 24: Could not open output file
 */
if (exitCode >= 12) {
    throw new ExitCodeException("An error occured when running the convert request. Exit code: ${exitCode}")
}
else if (failOnWarning && exitCode == 8) {
    throw new ExitCodeException("An warning occured when running the convert request. Exit code: ${exitCode}")
}