package com.urbancode.air.plugin.optim

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.ExitCodeException

public class OptimHelper {
    def apTool
    def props = []
    def args
    def workDir
    def optimCmd
    def requestName
    def optimDir
    def override
    def outputFile
    
    public OptimHelper (def propsIn) {
        props = propsIn
        workDir = new File(".")
        optimCmd = props['optimcmd']
        requestName = props['requestName']
        optimDir = props['optimDir']
        override = props['override']
        outputFile = props['output'] ? new File(props['output']) : null
    }
    
    def handleInputOutput() {
        if (override) {
            def inFile = new File(override)
            if (!inFile.absolute) {
                inFile = new File(workDir, override)
            }
            if (inFile.exists() && !inFile.directory) {
                println "Reading override file. Contents:"
                println inFile.getText()
                override = inFile.absolutePath
            }
            else {
                def tempInFile = File.createTempFile("optim-override", ".txt").with {
                    write override
                    println "Creating temp file: $absolutePath"
                    override = absolutePath
                }
            }
        }
        if (!outputFile) {
            outputFile = File.createTempFile("optim-output", ".txt")
            outputFile.deleteOnExit()
            println "Creating temporary output file: ${outputFile.absolutePath}"
        }
    }
    
    def runCommand(message, type) {
        def ch = new CommandHelper(workDir)
        ch.ignoreExitValue(true)
        def args = [optimCmd, "/R", "QUIET+", "P-", "type=${type}", "Request=\"${requestName}\"", "PST=\"${optimDir}\""]
        if (override) {
            args << "/OV=\"${override}\""
        }
        args << "OUTPUT=\"${outputFile.absolutePath}\""
        
        def exitCode = ch.runCommand(message, args)
        println outputFile.getText()
        return exitCode
    }
    
}