/**
* Licensed Materials - Property of IBM
* 5748-XX8
* (C) Copyright IBM Corp. 2014 All Rights Reserved
* US Government Users Restricted Rights - Use, duplication or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
**/

package com.ibm.rational.air.plugin.android;

import com.urbancode.air.CommandHelper;

/**
* A utility class for helping to run the Android commands.
**/
public class Util {
    /**
    * Handles adding the space-separated list or file of optional arguments.
    * arguments: A space-separated list or property file of arguments.
    * arg: The existing arguments for the command to which to append the passed 
    *     in arguments.
    * Returns an updated list of arguments for the command.
    **/
    public static def handleArgs(String arguments, def args) {
        // Check if the argument is a file or arguments
        def inFile = new File(arguments);
        if(!inFile.absolute) {
            def workDir = new File('.').getCanonicalFile();
            inFile = new File(workDir, arguments);
        }
        
        if(inFile.file) {
            arguments = inFile.getText();
            System.out.println("Reading from: " + inFile.getCanonicalFile());
        }
        
        // Get rid of new line characters if they are added.
        // Add the passed in arguments to the existing args.
        def argList = arguments.denormalize();
        argList.split(" ").each { arg ->
            arg.eachLine { it ->
                if(it?.trim()) {
                    args << it.trim()
                }
            }
        }
        
        return args;
    }
}