/**
* Licensed Materials - Property of IBM
* 5748-XX8
* (C) Copyright IBM Corp. 2013, 2014 All Rights Reserved
* US Government Users Restricted Rights - Use, duplication or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
**/

import com.urbancode.air.AirPluginTool;
import com.ibm.rational.air.plugin.android.ADBCommandHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

def pathToSDK = props['pathToSDK']
def appPath = props['appPath']
def target = props['target']
def serialNumber = props['serialNumber']
boolean reinstall = Boolean.parseBoolean(props['reinstall'])
def additionalArgs = props['additionalArgs']

try {
    def app = new File(appPath)
    def fileName = app.getName();
	if(!app.isFile() || !fileName.endsWith(".apk")) {
		println "The ${fileName} application file name must exist and include the apk extension."
		System.exit(1)
    }
} catch (Exception e) {
    println "An error occurred during the search for the application file: ${e.message}"
    System.exit(1)
}
    
def adbHelper = new ADBCommandHelper(pathToSDK, apTool.isWindows, target, serialNumber);
adbHelper.printVersion();
adbHelper.installApp(reinstall, appPath, additionalArgs);