/**
* Licensed Materials - Property of IBM
* 5748-XX8
* (C) Copyright IBM Corp. 2013, 2014 All Rights Reserved
* US Government Users Restricted Rights - Use, duplication or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
**/

import com.urbancode.air.AirPluginTool;
import com.ibm.rational.air.plugin.android.ADBCommandHelper;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

def pathToSDK = props['pathToSDK']
def jars = props['jars']
def jarPath = props['jarPath']
def classes = props['classes']
def target = props['target']
def serialNumber = props['serialNumber']
def additionalArgs = props['additionalArgs']
boolean cleanupJars = Boolean.parseBoolean(props['cleanupJars'])
def timeout = props['timeout']

def adbHelper = new ADBCommandHelper(pathToSDK, apTool.isWindows, target, serialNumber);
adbHelper.printVersion();
def result
if(jarPath) {
    adbHelper.pushFilesToTarget(jarPath, jars);
}

// Store the result to allow cleanup if the test fails.
result = adbHelper.uiTest(jars, classes, additionalArgs, timeout);

if(cleanupJars) {
    adbHelper.removeFilesFromTarget(jarPath, jars);
}
System.exit(result);
