/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic;

import com.ibm.issr.iet.weblogic.WebLogicMBeanServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicConnection {
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String USER = "userid";
    public static final String PASSWORD = "password";
    public static final String TIMEOUT = "timeout";
    public static final String LANG_STRING = "java.lang.String";
    private MBeanServerConnection connection = null;
    private JMXConnector connector = null;
    private WebLogicMBeanServer mBeanServer;

    public WebLogicConnection(String hostname, String portString, String username, String password, WebLogicMBeanServer server, Map<String, Object> connectionParams, String timeout) throws MalformedURLException, IOException {
        this.mBeanServer = server;
        this.initConnection(hostname, portString, username, password, connectionParams, timeout);
    }

    public WebLogicConnection(String hostname, String portString, String username, String password, WebLogicMBeanServer server, String timeout) throws MalformedURLException, IOException {
        this(hostname, portString, username, password, server, null, timeout);
    }

    public WebLogicConnection(String hostname, String portString, String username, String password, WebLogicMBeanServer server) throws MalformedURLException, IOException {
        this(hostname, portString, username, password, server, null, null);
    }

    public void closeConnection() {
        try {
            if (this.connector != null) {
                System.out.println("Closing connection...");
                this.connector.close();
                System.out.println("Connection Closed");
            }
        }
        catch (Exception e) {
            System.out.println("Failure while closing the connection and stopping edit session" + e.getMessage());
        }
    }

    public WebLogicMBeanServer getServerType() {
        return this.mBeanServer;
    }

    private void initConnection(String hostname, String portString, String username, String password, Map<String, Object> params, String timeout) throws IOException, MalformedURLException {
        String protocol = "t3";
        Integer portInteger = Integer.valueOf(portString);
        int port = portInteger;
        JMXServiceURL serviceURL = new JMXServiceURL(protocol, hostname, port, this.mBeanServer.getPath());
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("java.naming.security.principal", username);
        h.put("java.naming.security.credentials", password);
        h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        h.put("jmx.remote.x.request.waiting.timeout", this.getTimeout(timeout));
        if (params != null) {
            h.putAll(params);
        }
        this.connector = JMXConnectorFactory.connect(serviceURL, h);
        this.connection = this.connector.getMBeanServerConnection();
    }

    protected Long getTimeout(String timeout) {
        Long timeoutValue;
        try {
            timeoutValue = Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            timeoutValue = new Long(30000L);
        }
        return timeoutValue;
    }

    public MBeanServerConnection getServerConnection() {
        return this.connection;
    }

    public static String digupExceptionCause(Throwable e) {
        if (e.getCause() != null) {
            return WebLogicConnection.digupExceptionCause(e.getCause());
        }
        String message = e.getMessage();
        String failLoadClass = "Failed to load class";
        if (message != null && message.contains(failLoadClass)) {
            message = message.replace(failLoadClass, "");
        } else {
            e.printStackTrace();
        }
        return message;
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        StringBuilder objectName = new StringBuilder("com.bea:Name=");
        objectName.append(name).append(",Type=").append(this.mBeanServer.getMBeanServer()).append(".").append(name).append("MBean");
        return new ObjectName(objectName.toString());
    }

    public Object invoke(String name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, MalformedObjectNameException {
        return this.invoke(this.getObjectName(name), operationName, params, signature);
    }

    public Object invoke(ObjectName serviceName, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if ((params != null || signature != null) && params.length != signature.length) {
            throw new InvalidParameterException("The amount of parameter types does not match the amount of parameters");
        }
        return this.connection.invoke(serviceName, operationName, params, signature);
    }

    public Object invoke(ObjectName serviceName, String operationName, Map<Object, String> parameters) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object[] params = new Object[parameters.size()];
        String[] signatures = new String[parameters.size()];
        int count = 0;
        for (Map.Entry<Object, String> entry : parameters.entrySet()) {
            params[count] = entry.getKey();
            signatures[count] = entry.getValue();
            ++count;
        }
        return this.connection.invoke(serviceName, operationName, params, signatures);
    }
}

