/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.osbcm.OsbcmHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()
String userid          = inProps['userid']
String password        = inProps['password']
String hostname        = inProps['hostname']
String port            = inProps['port']
String uploadFile      = inProps['uploadFile']
String timeout         = inProps['timeout']
String pluginClasspath = inProps['pluginClasspath']

// Set up session
boolean created = OsbcmHelper.createSession(hostname, port, userid, password, timeout)
if (!created) {
    System.exit(1)
}
boolean configured = OsbcmHelper.configureSession()
if (!configured) {
    System.exit(1)
}

boolean customized = OsbcmHelper.loadCustomization(uploadFile)
if (!customized) {
    System.exit(1)
}

boolean activated = OsbcmHelper.activateSession()
if (!activated) {
    System.exit(1)
}

OsbcmHelper.closeConnection()
