/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic;

import com.ibm.issr.iet.weblogic.WebLogicConnection;
import com.ibm.issr.iet.weblogic.WebLogicHandler;
import com.ibm.issr.iet.weblogic.WebLogicMBeanServer;
import com.ibm.issr.iet.weblogic.beans.JMXProperty;
import com.ibm.issr.iet.weblogic.beans.JMXSubType;
import com.ibm.issr.iet.weblogic.configuration.WSLMetadata;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.NameNotFoundException;
import weblogic.descriptor.BeanAlreadyExistsException;

public class WebLogicSecurityHandler
extends WebLogicHandler {
    public static final String REALM = "Realm";
    public static final String ROLE_MAPPER = "RoleMapper";
    public static final String AUTHENTICATION_PROVIDER = "AuthenticationProvider";

    public WebLogicSecurityHandler(WebLogicConnection webLogicConnection) {
        super(webLogicConnection);
    }

    public void addUserToGroup(ObjectName provider, String groupName, String userName) throws InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        this.validateRuntimeServer();
        try {
            this.webLogicConnection.invoke(provider, "addMemberToGroup", new Object[]{groupName, userName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MBeanException ex) {
            Exception e = ex.getTargetException();
            if (e instanceof NameNotFoundException) {
                System.out.println(String.format("Group %s was not found.", groupName));
            }
            throw ex;
        }
    }

    public void removeUserFromGroup(ObjectName provider, String groupName, String userName) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.validateRuntimeServer();
        this.webLogicConnection.invoke(provider, "removeMemberFromGroup", new Object[]{groupName, userName}, new String[]{"java.lang.String", "java.lang.String"});
    }

    public void createGroup(ObjectName provider, String groupName, String description) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.validateRuntimeServer();
        try {
            this.webLogicConnection.invoke(provider, "createGroup", new Object[]{groupName, description}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MBeanException ex) {
            Exception e = ex.getTargetException();
            if (e instanceof BeanAlreadyExistsException) {
                System.out.println(String.format("Group %s already exist", groupName));
            }
            throw ex;
        }
    }

    public void removeGroup(ObjectName provider, String groupName) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.validateRuntimeServer();
        this.webLogicConnection.invoke(provider, "removeGroup", new Object[]{groupName}, new String[]{"java.lang.String"});
    }

    public void createUser(ObjectName provider, String userName, String userPassword, String userDescription) throws InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        this.validateRuntimeServer();
        try {
            this.webLogicConnection.invoke(provider, "createUser", new Object[]{userName, userPassword, userDescription}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
        }
        catch (MBeanException ex) {
            Exception e = ex.getTargetException();
            if (e instanceof BeanAlreadyExistsException) {
                System.out.println(String.format("User %s already exist", userName));
            }
            throw ex;
        }
    }

    public void removeUser(ObjectName provider, String userName) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.validateRuntimeServer();
        this.webLogicConnection.invoke(provider, "removeUser", new Object[]{userName}, new String[]{"java.lang.String"});
    }

    public ObjectName lookupAuthenticationProvider(String realmName, String providerName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, IntrospectionException, AttributeNotFoundException {
        ObjectName realm = this.lookupRealm(realmName);
        HashMap<Object, String> params = new HashMap<Object, String>();
        params.put(providerName, "java.lang.String");
        ObjectName provider = this.lookup(realm, params, WSLMetadata.getInstance().getJMXBean(AUTHENTICATION_PROVIDER));
        return provider;
    }

    private String resolveAuthenticatorByName(String providerName) throws AttributeNotFoundException {
        String type = null;
        try {
            type = ((JMXSubType)WSLMetadata.getInstance().getJMXBean(AUTHENTICATION_PROVIDER).getProperty(providerName)).getInterfaceName();
        }
        catch (AttributeNotFoundException e) {
            Collection<JMXProperty> properties = WSLMetadata.getInstance().getJMXBean(AUTHENTICATION_PROVIDER).getProperties().values();
            for (JMXProperty property : properties) {
                String interfaceName;
                if (!(property instanceof JMXSubType) || !(interfaceName = ((JMXSubType)property).getInterfaceName()).equals(providerName)) continue;
                type = interfaceName;
            }
        }
        if (type == null) {
            throw new AttributeNotFoundException(String.format("Authentication provider %s not found", providerName));
        }
        return type;
    }

    public ObjectName lookupRealm(String realmName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.validateRuntimeServer();
        ObjectName service = this.webLogicConnection.getObjectName("DomainRuntimeService");
        ObjectName domainConfig = this.getAttribute(service, "DomainConfiguration", ObjectName.class);
        ObjectName securityConfig = this.getAttribute(domainConfig, "SecurityConfiguration", ObjectName.class);
        HashMap<Object, String> params = new HashMap<Object, String>();
        params.put(realmName, "java.lang.String");
        ObjectName realm = this.lookup(securityConfig, params, WSLMetadata.getInstance().getJMXBean(REALM));
        return realm;
    }

    private void validateRuntimeServer() {
        if (this.webLogicConnection.getServerType() != WebLogicMBeanServer.RUNTIME) {
            throw new UnsupportedOperationException("Security actions are not compatible with " + this.webLogicConnection.getServerType().getMBeanServer());
        }
    }

    public ObjectName createAuthenticator(String realmName, String providerName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, AttributeNotFoundException {
        ObjectName realm = this.lookupRealm(realmName);
        HashMap<Object, String> params = new HashMap<Object, String>();
        params.put(this.resolveAuthenticatorByName(providerName), "java.lang.String");
        return this.create(realm, params, WSLMetadata.getInstance().getJMXBean(AUTHENTICATION_PROVIDER));
    }

    private void validateRoleName(String roleName) {
        if (roleName == null || roleName.equals("")) {
            throw new InvalidParameterException("Role name must not be empty");
        }
    }

    public void createRole(ObjectName provider, String resourceId, String roleName, String expression, String auxiliary) throws InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        this.validateRuntimeServer();
        this.validateRoleName(roleName);
        try {
            this.webLogicConnection.invoke(provider, "createRole", new Object[]{resourceId, roleName, expression, auxiliary}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
        }
        catch (MBeanException ex) {
            Exception e = ex.getTargetException();
            if (e instanceof BeanAlreadyExistsException) {
                System.out.println(String.format("Role %s already exist", roleName));
            }
            throw ex;
        }
    }

    public void removeRole(ObjectName provider, String resourceId, String roleName) throws InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        this.validateRuntimeServer();
        this.validateRoleName(roleName);
        try {
            this.webLogicConnection.invoke(provider, "removeRole", new Object[]{resourceId, roleName}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (MBeanException ex) {
            Exception e = ex.getTargetException();
            if (e instanceof BeanAlreadyExistsException) {
                System.out.println(String.format("Role %s already exist", roleName));
            }
            throw ex;
        }
    }

    public void setRoleExpression(ObjectName provider, String resourceId, String roleName, String expression) throws InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        this.validateRuntimeServer();
        this.validateRoleName(roleName);
        this.webLogicConnection.invoke(provider, "setRoleExpression", new Object[]{resourceId, roleName, expression}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
    }

    public void setRoleAuxiliary(ObjectName provider, String resourceId, String roleName, String auxiliary) throws InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        this.validateRuntimeServer();
        this.validateRoleName(roleName);
        this.webLogicConnection.invoke(provider, "setRoleAuxiliary", new Object[]{resourceId, roleName, auxiliary}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
    }

    public ObjectName lookupRoleMapper(String realmName, String providerName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName realm = this.lookupRealm(realmName);
        HashMap<Object, String> params = new HashMap<Object, String>();
        params.put(providerName, "java.lang.String");
        ObjectName provider = this.lookup(realm, params, WSLMetadata.getInstance().getJMXBean(ROLE_MAPPER));
        return provider;
    }
}

