/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.weblogic;

import com.ibm.issr.iet.jmx.OrderedProperties;
import com.ibm.issr.iet.weblogic.JMXEditSession;
import com.ibm.issr.iet.weblogic.WebLogicConnection;
import com.ibm.issr.iet.weblogic.WebLogicMBeanServer;
import com.ibm.issr.iet.weblogic.beans.JMXAttribute;
import com.ibm.issr.iet.weblogic.beans.JMXBean;
import com.ibm.issr.iet.weblogic.beans.JMXProperty;
import com.ibm.issr.iet.weblogic.beans.JMXPropertyType;
import com.ibm.issr.iet.weblogic.beans.JMXRelatedBean;
import com.ibm.issr.iet.weblogic.beans.JMXSubType;
import com.ibm.issr.iet.weblogic.configuration.WSLMetadata;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import weblogic.descriptor.BeanAlreadyExistsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicHandler {
    private static final String NAME = "Name";
    protected WebLogicConnection webLogicConnection;
    private JMXEditSession editSession = null;

    public WebLogicHandler(WebLogicConnection webLogicConnection) {
        this.webLogicConnection = webLogicConnection;
    }

    private MBeanServerConnection getConnection() {
        return this.webLogicConnection.getServerConnection();
    }

    public <T> T getAttribute(ObjectName object, String attribute, Class<T> clazz) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object attributeObject;
        try {
            attributeObject = this.getConnection().getAttribute(object, attribute);
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
        if (attributeObject == null) {
            return null;
        }
        if (clazz.isAssignableFrom(attributeObject.getClass())) {
            return (T)attributeObject;
        }
        throw new RuntimeException(String.format("%s is not assignable to %s", attributeObject.getClass().getName(), clazz.getName()));
    }

    public <T> T[] getAttributes(ObjectName object, String attribute, Class<T> clazz) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object attributeObject = null;
        try {
            attributeObject = this.getConnection().getAttribute(object, attribute);
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
        if (attributeObject == null) {
            return null;
        }
        Class<T> castClass = JMXPropertyType.getObjectType(attributeObject.getClass().getComponentType());
        if (castClass == null) {
            castClass = attributeObject.getClass().getComponentType();
        }
        if (castClass.isAssignableFrom(clazz)) {
            Object[] response = (Object[])Array.newInstance(castClass, Array.getLength(attributeObject));
            for (int i = 0; i < response.length; ++i) {
                response[i] = Array.get(attributeObject, i);
            }
            return response;
        }
        throw new RuntimeException(String.format("%s is not assignable to %s", attributeObject.getClass().getComponentType().getName(), clazz.getName()));
    }

    public void setAttributes(ObjectName target, ObjectName object, JMXBean bean, Map<String, Object> attributes) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException {
        this.setAttributes(target, object, bean, attributes, null);
    }

    public void setAttributes(ObjectName target, ObjectName object, JMXBean bean, Map<String, Object> attributes, Properties properties) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException {
        for (Map.Entry<String, Object> attributeEntry : attributes.entrySet()) {
            JMXAttribute property = (JMXAttribute)bean.getProperty(attributeEntry.getKey());
            if (property.isReadOnly()) {
                throw new InvalidAttributeValueException("Attribute " + property.getName() + " is read only attribute");
            }
            if (property.getType().getClassType().isAssignableFrom(attributeEntry.getValue().getClass()) || attributeEntry.getValue().getClass().isArray() && property.getType().getClassType().isAssignableFrom(attributeEntry.getValue().getClass().getComponentType())) {
                if (property.hasValidatedBy()) {
                    String param;
                    JMXBean validatingBean = WSLMetadata.getInstance().getJMXBean(property.getValidatedBy());
                    StringBuilder pathBuilder = this.resolvePath(validatingBean, properties);
                    int paramStart = pathBuilder.indexOf(param = "$" + validatingBean.getName());
                    if (paramStart < 0) {
                        throw new AttributeNotFoundException(String.format("Parameter %s not found, unable to resolve validating path %s", param, pathBuilder.toString()));
                    }
                    int end = paramStart + param.length();
                    pathBuilder.replace(paramStart, end, (String)attributeEntry.getValue());
                    ObjectName validObjectName = this.navigateTo(this.editSession.getDomainConfigRoot(), pathBuilder.toString());
                    if (validObjectName == null) {
                        throw new IllegalArgumentException(attributeEntry.getValue() + " does not exist as a valid " + property.getValidatedBy());
                    }
                }
                Object attributeValue = null;
                attributeValue = JMXPropertyType.parse(attributeEntry.getValue(), property.getType(), property.isArray());
                Attribute attribute = new Attribute(attributeEntry.getKey(), attributeValue);
                this.getConnection().setAttribute(object, attribute);
                continue;
            }
            throw new ClassCastException(attributeEntry.getValue() + " is not assignable to " + (Object)((Object)property.getType()));
        }
    }

    private StringBuilder resolvePath(JMXBean bean, Properties properties) {
        StringBuilder pathBuilder = new StringBuilder(bean.getPath());
        for (String param : bean.getParams()) {
            int paramStart = pathBuilder.indexOf("$" + param);
            if (properties.getProperty(param) == null) continue;
            pathBuilder.replace(paramStart, paramStart + param.length() + 1, properties.getProperty(param));
        }
        return pathBuilder;
    }

    public void setAttributes(JMXEditSession editSession, String path, Map<String, Object> attributes) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException {
        JMXBean bean = WSLMetadata.getInstance().getJMXBean(this.getBeanTypeFromPath(path));
        this.setAttributes(editSession.getConfigMgr(), this.navigateTo(editSession.getDomainConfigRoot(), path), bean, attributes);
    }

    public void comitChanges(JMXEditSession editSession, boolean save, boolean activate) throws InstanceNotFoundException, MalformedObjectNameException, MBeanException, ReflectionException, IOException {
        if (save) {
            System.out.println("Saving changes...");
            this.webLogicConnection.invoke(editSession.getConfigMgr(), "save", null, null);
            System.out.println("Changes Saved");
        }
        if (activate) {
            System.out.println("Activating changes...");
            this.webLogicConnection.invoke(editSession.getConfigMgr(), "activate", new Object[]{new Long(120000L)}, new String[]{"java.lang.Long"});
            System.out.println("Changes Activated");
        }
    }

    public void cancelChanges(JMXEditSession editSession) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        System.out.println("Cancelling changes...");
        this.webLogicConnection.invoke(editSession.getConfigMgr(), "undo", null, null);
        System.out.println("Changes cancelled");
    }

    public JMXEditSession startEditSession(ObjectName service) throws MBeanException, ReflectionException, IOException, OperationsException {
        System.out.println("Starting edit session");
        if (this.webLogicConnection.getServerType() != WebLogicMBeanServer.EDIT) {
            throw new UnsupportedOperationException("Edit session is not compatible with " + this.webLogicConnection.getServerType().getMBeanServer());
        }
        if (this.editSession == null) {
            ObjectName cfgMgr = (ObjectName)this.getConnection().getAttribute(service, "ConfigurationManager");
            ObjectName domainConfigRoot = (ObjectName)this.webLogicConnection.invoke(cfgMgr, "startEdit", new Object[]{new Integer(60000), new Integer(120000)}, new String[]{"java.lang.Integer", "java.lang.Integer"});
            if (domainConfigRoot == null) {
                throw new OperationsException("Somebody else is editing already");
            }
            this.editSession = new JMXEditSession(domainConfigRoot, cfgMgr);
        }
        System.out.println("Edit session started");
        return this.editSession;
    }

    public void stopEditSession() {
        if (this.editSession != null) {
            try {
                System.out.println("Stopping edit session...");
                this.webLogicConnection.invoke(this.editSession.getConfigMgr(), "stopEdit", null, null);
                System.out.println("Edit session stopped");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ObjectName lookup(ObjectName resourceParent, Map<Object, String> params, JMXBean bean) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName result = (ObjectName)this.webLogicConnection.invoke(resourceParent, bean.getLookup(), params.keySet().toArray(new Object[0]), params.values().toArray(new String[0]));
        return result;
    }

    public ObjectName create(ObjectName target, String resourcePath) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException, AttributeNotFoundException {
        HashMap<Object, String> params = new HashMap<Object, String>();
        return this.create(target, resourcePath, params);
    }

    public ObjectName create(ObjectName target, String resourcePath, Map<Object, String> params) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException, AttributeNotFoundException {
        String objectName = this.getObjectNameFromPath(resourcePath);
        String beanType = this.getBeanTypeFromPath(resourcePath);
        JMXBean bean = WSLMetadata.getInstance().getJMXBean(beanType);
        if (bean.hasSubTypes()) {
            JMXSubType subType = (JMXSubType)bean.getProperty(objectName);
            objectName = subType.getCreationName();
        }
        params.put(objectName, "java.lang.String");
        return this.create(this.getParentObjectName(target, resourcePath), params, bean);
    }

    public ObjectName create(ObjectName resourceParent, Map<Object, String> params, JMXBean bean) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName result = (ObjectName)this.webLogicConnection.invoke(resourceParent, bean.getCreate(), params.keySet().toArray(new Object[0]), params.values().toArray(new String[0]));
        return result;
    }

    private ObjectName getParentObjectName(ObjectName parent, String resourcePath) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, IllegalArgumentException {
        ObjectName resourceParent = this.navigateTo(parent, this.getParentPath(resourcePath));
        return resourceParent;
    }

    public String getObjectNameFromPath(String resourcePath) {
        int startObjectName;
        StringBuilder path = new StringBuilder(resourcePath);
        int lastNodeIndex = path.lastIndexOf("/");
        if (lastNodeIndex >= 0) {
            path = path.delete(0, lastNodeIndex + 1);
        }
        if ((lastNodeIndex = path.lastIndexOf(":")) > 0) {
            path = path.delete(0, lastNodeIndex + 1);
        }
        if ((startObjectName = path.indexOf("[")) > 0) {
            path.delete(0, startObjectName + 1);
            path.deleteCharAt(path.indexOf("]"));
        }
        return path.toString();
    }

    public String getBeanTypeFromPath(String resourcePath) {
        StringBuilder path = new StringBuilder(resourcePath);
        int lastNodeIndex = path.lastIndexOf("/");
        if (lastNodeIndex >= 0) {
            path = path.delete(0, lastNodeIndex + 1);
        }
        if ((lastNodeIndex = path.lastIndexOf(":")) > 0) {
            path = path.delete(lastNodeIndex, path.length());
        }
        return path.toString();
    }

    public String getParentPath(String resourcePath) {
        int lastNodeIndex = resourcePath.lastIndexOf(47);
        if (lastNodeIndex >= 0) {
            resourcePath = resourcePath.substring(0, lastNodeIndex);
        }
        return resourcePath;
    }

    public ObjectName destroy(JMXEditSession editSession, String resourcePath) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException {
        ObjectName resource = this.navigateTo(editSession.getDomainConfigRoot(), resourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("The target resource to destroy does not exist: " + resourcePath);
        }
        ObjectName resourceParent = this.getParentObjectName(editSession.getDomainConfigRoot(), resourcePath);
        if (resourceParent == null) {
            throw new IllegalArgumentException("The target resource parent does not exist: " + resourcePath);
        }
        return this.destroy(resourceParent, resource, WSLMetadata.getInstance().getJMXBean(this.getBeanTypeFromPath(resourcePath)));
    }

    public ObjectName destroy(ObjectName resourceParent, ObjectName resource, JMXBean bean) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("The target resource to destroy must not be null");
        }
        if (resourceParent == null) {
            throw new IllegalArgumentException("The target resource parent must not be null");
        }
        ObjectName result = (ObjectName)this.webLogicConnection.invoke(resourceParent, bean.getDestroy(), new Object[]{resource}, new String[]{"javax.management.ObjectName"});
        return result;
    }

    public ObjectName navigateTo(ObjectName root, String path) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, IllegalArgumentException {
        String[] elements = path.split("/");
        ObjectName node = root;
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            if (element.matches(".*\\[.*\\]")) {
                HashMap<Object, String> params = new HashMap<Object, String>();
                String beanType = this.getBeanTypeFromPath(element);
                String lookupName = this.getObjectNameFromPath(element);
                params.put(lookupName, "java.lang.String");
                node = this.lookup(node, params, WSLMetadata.getInstance().getJMXBean(beanType));
            } else if (!element.equals("")) {
                node = this.getAttribute(node, this.getObjectNameFromPath(element), ObjectName.class);
            }
            if (node != null) continue;
            throw new IllegalArgumentException(String.format("The element %s was not found", element));
        }
        return node;
    }

    public void addBeanRelation(JMXEditSession editSession, ObjectName resource, String attribute, JMXBean bean, JMXRelatedBean property, Map<String, String> beanParams, boolean isPropertyParent) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IllegalArgumentException, IOException, AttributeNotFoundException, InvalidAttributeValueException {
        if (property.isReference()) {
            this.addRelatedBean(editSession, resource, bean, property, beanParams);
        } else {
            this.addContainedBean(resource, attribute, bean, property, beanParams, isPropertyParent);
        }
    }

    private void addContainedBean(ObjectName resource, String attribute, JMXBean bean, JMXRelatedBean property, Map<String, String> beanParams, boolean isPropertyParent) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException, MalformedObjectNameException, IllegalArgumentException {
        ObjectName containedBean = null;
        JMXBean relatedBean = null;
        containedBean = resource;
        boolean isNested = false;
        if (attribute.contains(".")) {
            isNested = true;
        }
        if (isNested) {
            String attributeName;
            JMXProperty nestedProperty;
            String[] beans = attribute.split("\\.");
            JMXBean innerBean = bean;
            String[] arr$ = beans;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (nestedProperty = innerBean.getProperty(attributeName = arr$[i$])) instanceof JMXRelatedBean; ++i$) {
                innerBean = WSLMetadata.getInstance().getJMXBean(((JMXRelatedBean)nestedProperty).getContainedBean());
            }
            relatedBean = innerBean;
        } else {
            relatedBean = WSLMetadata.getInstance().getJMXBean(property.getContainedBean());
        }
        for (Map.Entry<String, String> attributeEntry : beanParams.entrySet()) {
            JMXAttribute relatedAttribute = isPropertyParent ? (JMXAttribute)relatedBean.getProperty(attributeEntry.getKey()) : property;
            String[] value = null;
            if (relatedAttribute.isArray()) {
                String val = attributeEntry.getValue();
                if (val.matches("\\(.*\\).*")) {
                    ArrayList<Map<String, String>> arrayObjectsList = new ArrayList<Map<String, String>>();
                    this.getArrayObjectsFromValue(val, arrayObjectsList);
                    for (Map map : arrayObjectsList) {
                        String name = (String)map.get(NAME);
                        map.remove(NAME);
                        HashMap<Object, String> parameters = new HashMap<Object, String>();
                        parameters.put(name, "java.lang.String");
                        ObjectName object = null;
                        try {
                            object = (ObjectName)this.webLogicConnection.invoke(resource, ((JMXRelatedBean)relatedAttribute).getFactory(), parameters);
                            System.out.println("Array object " + name + " created");
                        }
                        catch (RuntimeMBeanException e) {
                            if (e.getTargetException() instanceof BeanAlreadyExistsException) {
                                ObjectName[] objects;
                                for (ObjectName obj : objects = this.getAttributes(resource, relatedAttribute.getName(), ObjectName.class)) {
                                    String objName = this.getAttribute(obj, NAME, String.class);
                                    if (!objName.equals(name)) continue;
                                    object = obj;
                                    System.out.println("Array object " + name + " found");
                                }
                            }
                            throw e;
                        }
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        relatedBean = WSLMetadata.getInstance().getJMXBean(((JMXRelatedBean)relatedAttribute).getRelatedBean());
                        for (Map.Entry paramEntry : map.entrySet()) {
                            JMXAttribute arrayAttributeProperty = (JMXAttribute)relatedBean.getProperty((String)paramEntry.getKey());
                            attributes.put((String)paramEntry.getKey(), JMXPropertyType.parse(paramEntry.getValue(), arrayAttributeProperty.getType(), arrayAttributeProperty.isArray()));
                        }
                        this.setAttributes(this.editSession.getConfigMgr(), object, relatedBean, attributes);
                    }
                    return;
                }
                String[] values = val.split(",");
                if (bean.hasSubTypes()) {
                    for (int i = 0; i < values.length; ++i) {
                        JMXSubType jMXSubType = (JMXSubType)bean.getProperty(values[i]);
                        values[i] = jMXSubType.getInterfaceName();
                    }
                }
                value = values;
            } else {
                value = attributeEntry.getValue();
            }
            Attribute attrib = new Attribute(attributeEntry.getKey(), JMXPropertyType.parse(value, relatedAttribute.getType(), relatedAttribute.isArray()));
            this.getConnection().setAttribute(containedBean, attrib);
        }
    }

    private void getArrayObjectsFromValue(String arrayParamValues, List<Map<String, String>> arrayObjectsList) {
        StringTokenizer tokenizer = new StringTokenizer(arrayParamValues, "(\\(*\\))(,)+");
        while (tokenizer.hasMoreElements()) {
            String arrayObjects = tokenizer.nextToken();
            if (!arrayObjects.contains(";")) continue;
            String[] properties = arrayObjects.split(";");
            HashMap<String, String> arrayObjectParams = new HashMap<String, String>();
            for (String prop : properties) {
                String[] valuePair = prop.split(":");
                arrayObjectParams.put(valuePair[0], valuePair[1]);
            }
            arrayObjectsList.add(arrayObjectParams);
        }
    }

    private void addRelatedBean(JMXEditSession editSession, ObjectName resource, JMXBean bean, JMXRelatedBean property, Map<String, String> beanParams) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, IllegalArgumentException, AttributeNotFoundException, InvalidAttributeValueException {
        ObjectName[] relatedBean;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        JMXBean referencedBean = WSLMetadata.getInstance().getJMXBean(property.getRelatedBean());
        if (property.isArray()) {
            String[] beanNames = beanParams.get(referencedBean.getName()).split(",");
            ObjectName[] relatedBeans = new ObjectName[beanNames.length];
            for (int i = 0; i < beanNames.length; ++i) {
                beanParams.put(referencedBean.getName(), beanNames[i]);
                relatedBeans[i] = this.getRelatedBean(editSession, resource, bean, property, beanParams, referencedBean);
            }
            relatedBean = relatedBeans;
        } else {
            relatedBean = this.getRelatedBean(editSession, resource, bean, property, beanParams, referencedBean);
        }
        attributes.put(property.getName(), relatedBean);
        this.setAttributes(editSession.getConfigMgr(), resource, bean, attributes);
    }

    private ObjectName getRelatedBean(JMXEditSession editSession, ObjectName resource, JMXBean bean, JMXRelatedBean property, Map<String, String> beanParams, JMXBean referencedBean) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, IllegalArgumentException, AttributeNotFoundException, InvalidAttributeValueException {
        StringBuilder relatedBeanPathBuilder = new StringBuilder(referencedBean.getPath());
        for (String param : referencedBean.getParams()) {
            int paramStart = relatedBeanPathBuilder.indexOf("$" + param);
            relatedBeanPathBuilder.replace(paramStart, paramStart + param.length() + 1, beanParams.get(param));
        }
        if (relatedBeanPathBuilder.toString().isEmpty()) {
            throw new AttributeNotFoundException(String.format("The referenced bean %s path is empty", referencedBean.getName()));
        }
        ObjectName relatedBean = this.navigateTo(editSession.getDomainConfigRoot(), relatedBeanPathBuilder.toString());
        if (relatedBean == null) {
            throw new AttributeNotFoundException(String.format("The referenced bean was not found at %s", relatedBeanPathBuilder.toString()));
        }
        return relatedBean;
    }

    public void closeConnection() {
        this.stopEditSession();
        this.webLogicConnection.closeConnection();
    }

    public JMXEditSession getEditSession(String serviceName) throws MalformedObjectNameException, MBeanException, ReflectionException, OperationsException, IOException {
        return this.startEditSession(this.webLogicConnection.getObjectName(serviceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrCreateBean(JMXBean bean, Properties inputProperties, OrderedProperties jmxProperties) throws MalformedObjectNameException, MBeanException, ReflectionException, OperationsException, IOException, IllegalArgumentException {
        try {
            if (this.editSession == null) {
                this.getEditSession("EditService");
            }
            System.out.println("Acquired Edit Session");
            StringBuilder pathBuilder = new StringBuilder(bean.getPath());
            for (String param : bean.getParams()) {
                int paramStart = pathBuilder.indexOf("$" + param);
                pathBuilder.replace(paramStart, paramStart + param.length() + 1, inputProperties.getProperty(param));
            }
            ObjectName createdBean = null;
            try {
                createdBean = this.navigateTo(this.editSession.getDomainConfigRoot(), pathBuilder.toString());
            }
            catch (IllegalArgumentException e) {
                createdBean = this.create(this.editSession.getDomainConfigRoot(), pathBuilder.toString(), new HashMap<Object, String>());
            }
            System.out.println("Acquired Bean");
            this.updateProperties(jmxProperties, createdBean, bean, inputProperties);
            try {
                this.comitChanges(this.editSession, true, true);
            }
            catch (Exception e) {
                this.cancelChanges(this.editSession);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBean(JMXBean bean, Properties inputProperties, OrderedProperties jmxProperties) throws MalformedObjectNameException, MBeanException, ReflectionException, OperationsException, IOException, IllegalArgumentException {
        try {
            this.editSession = this.getEditSession("EditService");
            StringBuilder pathBuilder = new StringBuilder(bean.getPath());
            for (String param : bean.getParams()) {
                int paramStart = pathBuilder.indexOf("$" + param);
                pathBuilder.replace(paramStart, paramStart + param.length() + 1, inputProperties.getProperty(param));
            }
            this.destroy(this.editSession, pathBuilder.toString());
            System.out.println(String.format("%s %s destroyed at %s", bean.getName(), this.getObjectNameFromPath(pathBuilder.toString()), this.getParentPath(pathBuilder.toString())));
            try {
                this.comitChanges(this.editSession, true, true);
            }
            catch (Exception e) {
                this.cancelChanges(this.editSession);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public void addRelatedBean(ObjectName object, JMXEditSession editSession, String referencedBeanType, String objectNameKey, JMXRelatedBean property, boolean isPropertyParent, Properties inputProperties, OrderedProperties jmxProperties, JMXBean bean) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IllegalArgumentException, IOException, AttributeNotFoundException, InvalidAttributeValueException {
        JMXBean relatedBean = WSLMetadata.getInstance().getJMXBean(referencedBeanType);
        HashMap<String, String> beanParams = new HashMap<String, String>();
        String attribute = null;
        if (property.isReference()) {
            int index = objectNameKey.indexOf(91);
            if (index > 0) {
                property.setRelatedBean(this.getSubProperty(objectNameKey));
            }
            for (String paramName : relatedBean.getParams()) {
                String value = null;
                if (paramName.equals(relatedBean.getName())) {
                    value = jmxProperties.getProperty(objectNameKey);
                    if (relatedBean.hasSubTypes()) {
                        value = ((JMXSubType)WSLMetadata.getInstance().getJMXBean(relatedBean.getName()).getProperty(value)).getInterfaceName();
                    }
                    if (property.isRelatedBeanSet()) {
                        paramName = property.getRelatedBean();
                    }
                    beanParams.put(paramName, value);
                    continue;
                }
                value = jmxProperties.getProperty(paramName);
                if (value == null) {
                    value = inputProperties.getProperty(paramName);
                }
                beanParams.put(paramName, value);
            }
        } else {
            String param;
            int lastSection = objectNameKey.lastIndexOf(".");
            if (lastSection > 0) {
                attribute = objectNameKey.substring(0, lastSection);
                param = objectNameKey.substring(lastSection + 1, objectNameKey.length());
            } else {
                attribute = objectNameKey;
                param = objectNameKey;
            }
            beanParams.put(param, jmxProperties.getProperty(objectNameKey));
        }
        this.addBeanRelation(editSession, object, attribute, bean, property, beanParams, isPropertyParent);
    }

    public String getSubProperty(String property) throws AttributeNotFoundException {
        JMXBean subBean;
        int index = property.indexOf(91) + 1;
        if (index > 0) {
            property = property.substring(index, property.length() - 1);
        }
        if ((subBean = WSLMetadata.getInstance().getJMXBean(property)) == null) {
            throw new AttributeNotFoundException(String.format("Subtype %s not found", property));
        }
        return subBean.getName();
    }

    public void updateProperties(OrderedProperties jmxProperties, ObjectName createdBean, JMXBean bean, Properties inputProperties) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, AttributeNotFoundException, InvalidAttributeValueException, IllegalArgumentException {
        HashMap<String, Object> jmxParams = new HashMap<String, Object>();
        Enumeration<Object> e = jmxProperties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.contains(".")) {
                String[] nestedBeans = key.split("\\.");
                ObjectName targetBean = createdBean;
                for (int i = 0; i < nestedBeans.length - 1; ++i) {
                    targetBean = this.getAttribute(targetBean, nestedBeans[i], ObjectName.class);
                }
                String objectNameKey = nestedBeans[0];
                JMXProperty property = bean.getProperty(objectNameKey);
                if (!(property instanceof JMXRelatedBean)) continue;
                this.addRelatedBean(targetBean, this.editSession, ((JMXRelatedBean)property).getRelatedBean(), key, (JMXRelatedBean)property, true, inputProperties, jmxProperties, bean);
                continue;
            }
            JMXProperty property = bean.getProperty(key);
            if (property instanceof JMXRelatedBean) {
                this.addRelatedBean(createdBean, this.editSession, ((JMXRelatedBean)property).getRelatedBean(), key, (JMXRelatedBean)property, false, inputProperties, jmxProperties, bean);
                continue;
            }
            if (!(property instanceof JMXAttribute)) continue;
            JMXAttribute jmxAttr = (JMXAttribute)property;
            if (jmxAttr.hasValidatedBy()) {
                HashMap<String, Object> jmxParam = new HashMap<String, Object>();
                jmxParam.put(key, JMXPropertyType.parse(jmxProperties.getProperty(key), jmxAttr.getType(), jmxAttr.isArray()));
                this.setAttributes(this.editSession.getConfigMgr(), createdBean, bean, jmxParam, inputProperties);
                continue;
            }
            jmxParams.put(key, JMXPropertyType.parse(jmxProperties.getProperty(key), jmxAttr.getType(), jmxAttr.isArray()));
        }
        this.setAttributes(this.editSession.getConfigMgr(), createdBean, bean, jmxParams);
    }
}

