/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.plugin.integration.AddComment
import com.urbancode.air.AirPluginTool

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

final String url                = props['url']
final String username           = props['username']
final String password           = props['password']

final String projectName        = props['projectName']
final String workItemId         = props['workItemId']
final String comment            = props['comment']
final String requestId          = props['requestId']
final String appProcId          = props['appProcId']
final String compProcId         = props['compProcId']
final String procId             = props['procId']
final boolean addCommentUrl     = props['addCommentUrl'].toBoolean()
final String serverUrl          = props['serverUrl']

AddComment ac = new AddComment()
ac.url = url
ac.username = username
ac.password = password

ac.projectName = projectName
ac.workItemId = workItemId
ac.comment = comment
ac.props = props
ac.requestId = requestId
ac.appProcId = appProcId
ac.compProcId = compProcId
ac.procId = procId
ac.addCommentUrl = addCommentUrl
ac.serverUrl = serverUrl

ac.execute()