/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.plugin.integration.*
import com.urbancode.air.AirPluginTool

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

final String url         = props['url'];
final String username    = props['username'];
final String password    = props['password'];

final String projectName = props['projectName']
final def workItemIds    = props['workItemId'].split("\n|,")*.trim() - ""
final String action      = props['action'];
final String newState    = props['newState']

ChangeDefectStatus cds = new ChangeDefectStatus()
cds.url = url
cds.username = username
cds.password = password

cds.projectName = projectName
cds.action = action
cds.newState = newState
cds.props = props

def results = [:]
for (workItemId in workItemIds) {
    cds.workItemId = workItemId
    results << ["${workItemId}":cds.execute()]

    println ""
    println "======================================"
    println ""
}

println "Summary: " + results.toString()
println ""

if (results.containsValue(false)) {
    println "[Error] One of the work items failed to update."
    System.exit(1)
} else {
        if (action) {
            println "[Success] The `${action}` action has been applied to all work items."
        } else {
            println "[Success] All work items are in the `${newState}` state."
        }
}
