/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import org.apache.http.entity.StringEntity
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.rtcworkitems.RTCWorkItemHelper;
import com.urbancode.air.XTrustProvider;
import org.apache.commons.io.IOUtils;

//currently unused, as creation is very arbitrary

def final createItem(String newItemString, def createUrl, HttpClient client) {
    HttpPost createMethod = null;
    try {
        createMethod = new HttpPost(createUrl);
		createMethod.setEntity(new StringEntity(newItemString));
		createMethod.setHeader("Content-type", "application/x-oslc-cm-change-request+xml");
		createMethod.setHeader("Accept", "application/x-oslc-cm-change-request+xml");
        def result = client.execute(createMethod);
        int statusCode = result.getStatusLine().getStatusCode()
        if (statusCode <300 && statusCode >=200) {
        	return statusCode;
        }
        else {
            StringWriter writer = new StringWriter()
            IOUtils.copy(result.getEntity().getContent(), writer)
            println writer.toString()
        	println newItemString
        	return statusCode;
        }
    }
    finally {
        if (createMethod != null) {
            createMethod.releaseConnection();
        }
    }
}


def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def username = props['username'];
def password = props['password'];
def projectName = props['projectName'];
def url = props['url'];
def defectName = props['defectName'];
def description = props['description'];
def type = props['type'];
def filedAgainst = props['filedAgainst']

HttpClientBuilder httpBuilder = new HttpClientBuilder();
httpBuilder.setTrustAllCerts(true);
HttpClient client = httpBuilder.buildClient();

XTrustProvider.install();
def rtcHelper = new RTCWorkItemHelper(props);
def catalogurl = rtcHelper.getCatalogUrl(client);
rtcHelper.authenticateRTCUser(catalogurl, client);
def servicesUrl = rtcHelper.getServicesUrl(catalogurl, client);
def workItemUrl = rtcHelper.getWorkItemUrl(servicesUrl, client);
def creationUrl = rtcHelper.getCreationUrl(servicesUrl, client);
def categoryUrl = rtcHelper.getCategoryUrl();
//just have to get a resource ID for filedagainst
//to retrieve a Category for "Filed Against"
//GET the url https://jazz.net/jazz09/oslc/categories.xml, search for the name provided, return the resource URL


//syntax for element with parameters 'dc:description'(test: Attrvalue, description);
def gBuilder = new groovy.xml.StreamingMarkupBuilder()
gBuilder.encoding = "UTF-8"
def newItem = {
  mkp.xmlDeclaration()
  mkp.declareNamespace('oslc_cm':'http://open-services.net/xmlns/cm/1.0/')
  mkp.declareNamespace('rtc_cm':'http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/')
  mkp.declareNamespace('rdf','http://www.w3.org/1999/02/22-rdf-syntax-ns#')
  mkp.declareNamespace('dc': 'http://purl.org/dc/terms/')
      'oslc_cm:ChangeRequest'{
        'dc:title'(defectName);
        'dc:description'(description);
        'rtc_cm:filedAgainst'('rdf:resource','https://jazz.net/jazz09/resource/itemOid/com.ibm.team.workitem.Category/_HeCKYY3GEd-Qg4SCxjlK9w')
      }
}
String newItemStr = gBuilder.bind(newItem)

def createResult = createItem(newItemStr, creationUrl, client);
if (createResult < 300 && createResult >= 200) {
	println("Successfully created work item.");
	System.exit(0);
} else {
	println("Failed to create work item. Result was ${createResult}");
	System.exit(1);
}

