/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.plugin.integration.CheckItemStatus
import com.urbancode.air.AirPluginTool

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final String url         = props['url']
final String username    = props['username']
final String password    = props['password']

final String projectName = props['projectName']
final String workItemId  = props['workItemId']
final String status      = props['status']

CheckItemStatus cis = new CheckItemStatus()
cis.url = url
cis.username = username
cis.password = password

cis.projectName = projectName
cis.workItemId = workItemId
cis.desiredStatus = status
cis.props = props

def actualStatus = cis.execute()

apTool.setOutputProperty("workItemStatus", actualStatus)
apTool.setOutputProperties()

if (status) {
    if (actualStatus.equals(status)) {
        println ("[Ok] Work Item Status of \"${actualStatus}\" equals checking status of \"${status}\"")
        System.exit(0)
    }
    else {
        println ("[Error] Work Item Status of \"${actualStatus}\" does not equal checking status of \"${status}\"")
        System.exit(1)
    }
}
else {
    println ("[Action] No status to check against, setting output property of workItemStatus=${actualStatus}")
    System.exit(0)
}
