/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/


import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.integration.CreateWorkItem

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final String url                    = props['url']
final String username               = props['username']
final String password               = props['password']

final String projectName            = props['projectName']
final String workItemType           = props['workItemType']
final String workItemSummary        = props['workItemSummary']
final String workItemDescription    = props['workItemDescription']
final String workItemTags           = props['workItemTags']
final String filedAgainst           = props['filedAgainst']
final String comment                = props['comment']
final String additionalAttributes   = props['additionalAttributes']
final String requestId              = props['requestId']
final String appProcId              = props['appProcId']
final String compProcId             = props['compProcId']
final String procId                 = props['procId']
final boolean addCommentUrl         = props['addCommentUrl'].toBoolean()
final String serverUrl              = props['serverUrl']
final boolean debug                 = props['debug'].toBoolean()

CreateWorkItem createWorkItem = new CreateWorkItem()
createWorkItem.apTool = apTool
createWorkItem.url = url
createWorkItem.username = username?.trim()
createWorkItem.password = password

createWorkItem.projectName = projectName?.trim()
createWorkItem.workItemType = workItemType?.trim()
createWorkItem.workItemSummary = workItemSummary?.trim()
createWorkItem.workItemDescription = workItemDescription?.trim()
createWorkItem.workItemTags = workItemTags.split("\n|,")*.trim()
createWorkItem.filedAgainst = filedAgainst?.trim()
createWorkItem.additionalAttributes = additionalAttributes?.trim()
createWorkItem.projectName = projectName?.trim()

createWorkItem.comment = comment
createWorkItem.props = props
createWorkItem.requestId = requestId
createWorkItem.appProcId = appProcId
createWorkItem.compProcId = compProcId
createWorkItem.procId = procId
createWorkItem.addCommentUrl = addCommentUrl
createWorkItem.serverUrl = serverUrl
createWorkItem.debug = debug

createWorkItem.execute()
