
# Script that creates a File Event Generator

from java.util import Date
from java.text import SimpleDateFormat
from java.lang import Integer

import com.bea.wli.mbconnector.file as fileeggen
import com.bea.wli.management.configuration as wlicfg
import java.lang.Boolean as bool
import java.util as util
import java.io as io
import jarray
import sys
import wlstModule as wlst
import traceback

print 'Starting the File Event Generation Configuration script .... '

pFile = io.FileInputStream(sys.argv[1])
properties = util.Properties()
properties.load(pFile)
userName=properties.getProperty('userName')
passWord=properties.getProperty('passWord')
URL=properties.getProperty('URL')
target=properties.getProperty('target')
propFile=properties.getProperty('PropFile')
ftpFileProps = io.FileInputStream(propFile)
properties.load(ftpFileProps)
domaindir=properties.getProperty('domaindir')
fileEgName=properties.getProperty('fileEgName')
fileChannel=properties.getProperty('fileChannel')
fileDirectory=properties.getProperty('fileDirectory')
errorDirectory=properties.getProperty('errorDirectory')
filePattern=properties.getProperty('filePattern')
pollingInterval=properties.getProperty('pollingInterval')
scanSubdirs=properties.getProperty('scanSubdirs')
appName=properties.getProperty('appName')
channel=properties.getProperty('channel')
fileTransferMode=properties.getProperty('fileTransferMode')
ftpHostName=properties.getProperty('ftpHostName')
ftpPassword=properties.getProperty('ftpPassword')
ftpUserName=properties.getProperty('ftpUserName')
ftpLocalDirectory=properties.getProperty('ftpLocalDirectory')

if connected != 'true':
   print 'Connecting to weblogic server .... '
   connect(userName,passWord,URL)
else:
   print 'Connected'

print 'Getting server MBean .... '
serverMBean = getMBean("Targets/" + target);

if serverMBean is None:
  print 'ERROR: Target Server ' + target + ' Does Not Exist'
  sys.exit(1)

# Note for created resources

now = Date()
df = SimpleDateFormat( "EEE, d MMM yyyy HH:mm:ss" )
theNotes = "Created by File Event Generation configuration script. "+ \
           df.format( now )

try:
	
    print "Creating File EG ", fileEgName
    fileeggen.FileConnGenerator.main(["-inName", fileEgName,"-outfile", domaindir + "/" + "WLIFileEG_" + fileEgName + ".jar"])
    print("config")
    wlst.config()

    print("getTarget")
    egCfgMBean = getTarget("FileEventGenerators/FileEventGenerators")

    cData = jarray.zeros( 1, wlicfg.FileEventGenChannelConfiguration )
    print("new file config")
    egMBean = egCfgMBean.newFileEventGenConfigurationMBean(fileEgName)
    
    print "new channel"
    cData[0] = wlicfg.FileEventGenChannelConfiguration()
    cData[0].setChannel(fileChannel)
    cData[0].setFileDirectory(fileDirectory)
    cData[0].setFilePattern(filePattern)
    pollingNumber = Integer.parseInt(pollingInterval)
    cData[0].setPollingInterval( pollingNumber)
    cData[0].setScanSubdirs( bool.valueOf(scanSubdirs))
    cData[0].setFileTransferMode( bool.valueOf(fileTransferMode))
    cData[0].setFtpHostName(ftpHostName)
    cData[0].setFtpPassword(ftpPassword)
    cData[0].setFtpUserName(ftpUserName)
    cData[0].setFtpLocalDirectory(ftpLocalDirectory)

#   cData[0].setSortByArrival( bool.valueOf(sortByArrival))
#   cData[0].setPostRead( postRead)
#   cData[0].setArchiveDirectory( archiveDirectory)
    cData[0].setErrorDirectory( errorDirectory)
#   cData[0].setReadLimit( readLimit)
#   cData[0].setPassByFileName( bool.valueOf( passByFileName) )
#   cData[0].setComment("Default channel")

    egMBean.setChannels(cData)
    
    appName = "WLIFileEG_" + fileEgName
    wlst.deploy( appName, domaindir + "/" + appName + ".jar", target, "nostage" )
    wlst.cd("Applications/" + appName)
    wlst.set("LoadOrder", 1500)
    wlst.cd("../..")

    print "script returns SUCCESS"   

except:
    print "ERROR: configuration"
    traceback.print_exc()
    sys.exit(1)
    
# Finished
print 'Disconnecting from server...'
disconnect('y')
print 'Finished.'
exit()
