
# Script that creates a File Event Generator

from java.util import Date
from java.text import SimpleDateFormat
from java.lang import Integer

import com.bea.wli.mbconnector.file as fileeggen
import com.bea.wli.management.configuration as wlicfg
import java.lang.Boolean as bool
import java.util as util
import java.io as io
import jarray
import sys
import wlstModule as wlst
import traceback

print 'Starting the File Event Generation Configuration script .... '

EGupdated = false

fileEgName = sys.argv[3]

pFile = io.FileInputStream(sys.argv[1])
properties = util.Properties()
properties.load(pFile)
userName=properties.getProperty('userName')
passWord=properties.getProperty('passWord')
URL=properties.getProperty('URL')
target=properties.getProperty('target')
propFile=properties.getProperty('PropFile')
fileFileProps = io.FileInputStream(propFile)
properties.load(fileFileProps)
domaindir=properties.getProperty('domaindir')
fileChannel=properties.getProperty('fileChannel')
fileDirectory=properties.getProperty('fileDirectory')
errorDirectory=properties.getProperty('errorDirectory')
filePattern=properties.getProperty('filePattern')
pollingInterval=properties.getProperty('pollingInterval')
scanSubdirs=properties.getProperty('scanSubdirs')
appName=properties.getProperty('appName')
	
if connected != 'true':
   print 'Connecting to weblogic server .... '
   connect(userName,passWord,URL)
else:
   print 'Connected'

print 'Getting server MBean .... '
serverMBean = getMBean("Targets/" + target);

if serverMBean is None:
  print 'ERROR: Target Server ' + target + ' Does Not Exist'
  sys.exit(1)
  
# Note for created resources

now = Date()
df = SimpleDateFormat( "EEE, d MMM yyyy HH:mm:ss" )
theNotes = "Created by File Event Generation configuration script. "+ \
           df.format( now )

try:

    print "Updating File EG ", fileEgName

    wlst.config()
    fEventGen = getTarget("FileEventGenerators/FileEventGenerators")
    fEventConfigs = fEventGen.getFileEventGenConfigurationMBeans()
    for fconf in fEventConfigs:
      fname = fconf.getEventGeneratorName()
      if fname == fileEgName:
        channels = fconf.getChannels()
        channels[0].setFileDirectory(fileDirectory)
        channels[0].setFilePattern(filePattern)
        pollingNumber = Integer.parseInt(pollingInterval)
        channels[0].setPollingInterval( pollingNumber)
        channels[0].setScanSubdirs( bool.valueOf(scanSubdirs))

#       channels[0].setSortByArrival( bool.valueOf(sortByArrival))
#       channels[0].setPostRead( postRead)
#       channels[0].setArchiveDirectory( archiveDirectory)
        channels[0].setErrorDirectory( errorDirectory)
#       channels[0].setReadLimit( readLimit)
#       channels[0].setPassByFileName( bool.valueOf( passByFileName) )
#       channels[0].setComment("Default channel")
        fconf.setChannels(channels)
        EGupdated = true
        break

    if EGupdated == false:
        raise Exception(fileEgName + ' does not exist. It cannot be updated.')
    


except:
    print "ERROR: configuration"
    traceback.print_exc()
    sys.exit(1)
    
print "script returns SUCCESS"   
# Finished
print 'Disconnecting from server...'
disconnect('y')
print 'Finished.'
exit()
