
# Script that creates a File Event Generator

from java.util import Date
from java.text import SimpleDateFormat
from java.lang import Integer

import com.bea.wli.mbconnector.file as fileeggen
import com.bea.wli.management.configuration as wlicfg
import java.lang.Boolean as bool
import java.util as util
import java.io as io
import jarray
import sys
import wlstModule as wlst
import traceback

print 'Starting the File Event Generation Configuration script .... '

EGupdated = false

fileEgName=sys.argv[3]

pFile = io.FileInputStream(sys.argv[1])
properties = util.Properties()
properties.load(pFile)
userName=properties.getProperty('userName')
passWord=properties.getProperty('passWord')
URL=properties.getProperty('URL')
target=properties.getProperty('target')
propFile=properties.getProperty('PropFile')
ftpFileProps = io.FileInputStream(propFile)
properties.load(ftpFileProps)
domaindir=properties.getProperty('domaindir')
#fileEgName=properties.getProperty('fileEgName')
fileChannel=properties.getProperty('fileChannel')
fileDirectory=properties.getProperty('fileDirectory')
errorDirectory=properties.getProperty('errorDirectory')
filePattern=properties.getProperty('filePattern')
pollingInterval=properties.getProperty('pollingInterval')
scanSubdirs=properties.getProperty('scanSubdirs')
appName=properties.getProperty('appName')
channel=properties.getProperty('channel')
fileTransferMode=properties.getProperty('fileTransferMode')
ftpHostName=properties.getProperty('ftpHostName')
ftpPassword=properties.getProperty('ftpPassword')
ftpUserName=properties.getProperty('ftpUserName')
ftpLocalDirectory=properties.getProperty('ftpLocalDirectory')

if connected != 'true':
   print 'Connecting to weblogic server .... '
   connect(userName,passWord,URL)
else:
   print 'Connected'

print 'Getting server MBean .... '
serverMBean = getMBean("Targets/" + target);

if serverMBean is None:
  print 'ERROR: Target Server ' + target + ' Does Not Exist'
  sys.exit(1)

# Note for created resources

now = Date()
df = SimpleDateFormat( "EEE, d MMM yyyy HH:mm:ss" )
theNotes = "Created by File Event Generation configuration script. "+ \
           df.format( now )

try:
	
    print "Updating File EG ", fileEgName
#    fileeggen.FileConnGenerator.main(["-inName", fileEgName,"-outfile", domaindir + "/" + "WLIFileEG_" + fileEgName + ".jar"])
    print("config")
    wlst.config()

    print("getTarget")
    fEventGen = getTarget("FileEventGenerators/FileEventGenerators")
	
    print("update file config")
    fEventConfigs = fEventGen.getFileEventGenConfigurationMBeans()

    for fconf in fEventConfigs:
      fname = fconf.getEventGeneratorName()
      if fname == fileEgName:
        channels = fconf.getChannels()
        channels[0].setFileDirectory(fileDirectory)
        channels[0].setFilePattern(filePattern)
        pollingNumber = Integer.parseInt(pollingInterval)
        channels[0].setPollingInterval( pollingNumber)
        channels[0].setScanSubdirs( bool.valueOf(scanSubdirs))
        channels[0].setFileTransferMode( bool.valueOf(fileTransferMode))
        channels[0].setFtpHostName(ftpHostName)
        channels[0].setFtpPassword(ftpPassword)
        channels[0].setFtpUserName(ftpUserName)
        channels[0].setFtpLocalDirectory(ftpLocalDirectory)

#       channels[0].setSortByArrival( bool.valueOf(sortByArrival))
#       channels[0].setPostRead( postRead)
#       channels[0].setArchiveDirectory( archiveDirectory)
        channels[0].setErrorDirectory( errorDirectory)
#       channels[0].setReadLimit( readLimit)
#       channels[0].setPassByFileName( bool.valueOf( passByFileName) )
#       channels[0].setComment("Default channel")
        fconf.setChannels(channels)
        EGupdated = true
        break
    
#    appName = "WLIFileEG_" + fileEgName
#    wlst.deploy( appName, domaindir + "/" + appName + ".jar", adminServerName, "nostage" )
#    wlst.cd("Applications/" + appName)
#    wlst.set("LoadOrder", 1500)
#    wlst.cd("../..")

    if EGupdated == false:
        raise Exception(fileEgName + ' does not exist. It cannot be updated.')
        

except:
    print "ERROR: configuration"
    traceback.print_exc()
    sys.exit(1)
    
print "script returns SUCCESS"   
# Finished
print 'Disconnecting from server...'
disconnect('y')
print 'Finished.'
exit()
