import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper
import java.lang.Runtime

def apTool = new AirPluginTool(this.args[0], this.args[1])
def pythonScript = this.args[2]
def isWindows = apTool.isWindows

def props = apTool.getStepProperties()
def domainEnvPath = props['weblogicDomainPath']
def pythonPath = props['weblogicPythonPath']
def objectName = props['objectName'] != null ? props['objectName'] : "null"
final def PLUGIN_HOME = System.getenv('PLUGIN_HOME')

def wlCommand = "wlst"
def domainCommand = "setDomainEnv"
def executeCommand = "execute"

if (isWindows) {
    wlCommand = wlCommand + ".cmd"
    domainCommand = domainCommand + ".cmd"
    executeCommand = executeCommand + ".cmd"
}
else {
    wlCommand = wlCommand + ".sh"
    domainCommand = domainCommand + ".sh"
    executeCommand = executeCommand + ".sh"
}

while (pythonPath.endsWith(File.separator)) {
    pythonPath = pythonPath.substring(0, pythonPath.length() - 1);
}

wlCommand = pythonPath + File.separator + wlCommand

while (domainEnvPath.endsWith(File.separator)) {
    domainEnvPath = domainEnvPath.substring(0, domainEnvPath.length() - 1);
}

domainCommand = domainEnvPath + File.separator + domainCommand

//String[] cmdArgs = [wlCommand, pythonScript, this.args[0], this.args[1]]
def cmdArgs = []
cmdArgs << PLUGIN_HOME+File.separator+executeCommand << pythonPath << domainCommand <<  wlCommand << pythonScript << this.args[0] << this.args[1] << objectName

CommandHelper ch = new CommandHelper(new File("."))

ch.runCommand("Setting domain classpath and running WLST", cmdArgs)

//ch.runCommand("Running WLST command", cmdArgs)
