
# Script that configures the base resources for a standalone host processing server.

from java.util import Date
from java.text import SimpleDateFormat
from java.lang import Integer

#import weblogic.Deployer
import com.bea.wli.mbconnector.jms as jmsegen 
import com.bea.wli.management.configuration as wlicfg
import java.lang.Boolean as bool
import java.util as util
import java.io as io
import jarray
import sys
import wlstModule as wlst
import traceback

print 'Starting the JMS Event Generation Configuration script .... '

pFile = io.FileInputStream(sys.argv[1])
properties = util.Properties()
properties.load(pFile)
userName=properties.getProperty('userName')
passWord=properties.getProperty('passWord')
URL=properties.getProperty('URL')
target=properties.getProperty('target')
propFile=properties.getProperty('PropFile')
jmsFileProps = io.FileInputStream(propFile)
properties.load(jmsFileProps)
domaindir=properties.getProperty('domaindir')
jmsEgName=properties.getProperty('jmsEgName')
jndiName=properties.getProperty('jndiName')
destinationType=properties.getProperty('destinationType')
connectionFactoryJndiName=properties.getProperty('connectionFactoryJndiName')
appName=properties.getProperty('appName')
channel=properties.getProperty('channel')
jmsPropertyName=properties.getProperty('jmsPropertyName')
jmsPropertyValue=properties.getProperty('jmsPropertyValue')

if connected != 'true':
   print 'Connecting to weblogic server .... '
   connect(userName,passWord,URL)
else:
   print 'Connected'

print 'Getting server MBean .... '
serverMBean = getMBean("Targets/" + target);

if serverMBean is None:
  print 'ERROR: Target Server ' + target + ' Not Exist'
  sys.exit(1)

# Note for created resources

now = Date()
df = SimpleDateFormat( "EEE, d MMM yyyy HH:mm:ss" )
theNotes = "Created by JMS Event Generation configuration script. "+ \
           df.format( now )
exitcode = '0'
try:

    print "Creating JMS EG :", jmsEgName
    jmsegen.JmsConnGenerator.main(["-inName", jmsEgName,"-outfile", domaindir + "/" + "WLIJmsEG_" + jmsEgName + ".jar","-destJNDIName", jndiName,"-destType", destinationType,"-connectionFactoryJndiName", connectionFactoryJndiName])
    print 'Getting WLST configuration...'
    wlst.config()
    print 'Getting target for JMS EG...'
    egCfgMBean = getTarget("JMSEventGenerators/JMSEventGenerators")
    print 'Preparing channel data...'
    cData = jarray.zeros( 1, wlicfg.JMSEventGenChannelConfiguration )
    print 'Setting...'
    print 'Name:',jmsEgName
    print 'JNDI Name:',jndiName
    print 'Connection Factory:',connectionFactoryJndiName
    print 'Destination Type:',destinationType
    version = cmo.getConfigurationVersion()
    firstnumber = version.split('.')
    if firstnumber[0]=='10':
        print 'found version 10'
        egMBean = egCfgMBean.newJMSEventGenConfigurationMBean(jmsEgName,jndiName,connectionFactoryJndiName,destinationType)
        print 'Settings set, adding channel property...'
        cData[0] = wlicfg.JMSEventGenChannelConfiguration()
        cData[0].setChannel(channel)
        print 'JMS Property Name:',jmsPropertyName
        cData[0].setMatchJmsPropertyName(jmsPropertyName)
        print 'JMS Property Value:',jmsPropertyValue
        cData[0].setMatchJmsPropertyValue(jmsPropertyValue)
    elif firstnumber[0]=='9':
        print 'found version 9'
        egMBean = egCfgMBean.newJMSEventGenConfigurationMBean(jmsEgName,jndiName,connectionFactoryJndiName)
        print 'Settings set, adding channel property...'
        cData[0] = wlicfg.JMSEventGenChannelConfiguration()
        cData[0].setChannel(channel)
    print 'Setting channel data...'
    egMBean.setChannels(cData)
    print 'Deploying...'
    appName = "WLIJmsEG_" + jmsEgName
    wlst.deploy( appName, domaindir + "/" + appName + ".jar", target, "nostage" )
    wlst.cd("Applications/" + appName)
    wlst.set("LoadOrder", 1500)
    wlst.cd("../..")
    
    print "script returns SUCCESS"   
except:
    print "ERROR: configuration"
    print 'Found exception while trying to create the JMS Event Generator.'
    traceback.print_exc()
    sys.exit(1)

# Finished
print 'Disconnecting from server...'
disconnect('y')
print 'Finished.'
exit(exitcode)
