/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.issr.iet.util.xml;

import com.ibm.issr.iet.util.xml.DocumentNamespaceContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    public static final String XML_APACHE_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private boolean throwExceptions = true;
    public final XPath xhtmlXPath = this.getXhtmlXPath();
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    Transformer transformer = null;

    public XPath getXhtmlXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NamespaceContext ctx = new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                String uri = "xhtml".equals(prefix) ? "http://www.w3.org/1999/xhtml" : null;
                return uri;
            }

            public Iterator getPrefixes(String val) {
                return Collections.EMPTY_LIST.iterator();
            }

            public String getPrefix(String uri) {
                return null;
            }
        };
        xpath.setNamespaceContext(ctx);
        return xpath;
    }

    public String getNodeValue(Document srcDom, String xPathQuery) throws XPathExpressionException {
        Node node = this.xPathQuery(srcDom, xPathQuery, Node.class);
        return node == null ? "" : node.getNodeValue();
    }

    public Document loadDOMInputSource(InputSource inputSource, boolean namespaceAware) {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = this.getDocumentBuilder(namespaceAware);
            if (inputSource == null) {
                return documentBuilder.newDocument();
            }
            return documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public DocumentBuilder getDocumentBuilder(boolean namespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(namespaceAware);
        DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }

    public final Document loadDOMFile(File file, boolean namespaceAware) throws FileNotFoundException {
        return this.loadDOMInputStream(new FileInputStream(file), namespaceAware);
    }

    public Document loadDOMFromResource(String resName, ClassLoader classLoader, boolean namespaceAware) throws IOException {
        return this.loadDOMInputStream(classLoader.getResourceAsStream(resName));
    }

    public final Document loadDOMInputStream(InputStream inputStream) {
        return this.loadDOMInputStream(inputStream, true);
    }

    public final Document loadDOMInputStream(InputStream inputStream, boolean namespaceAware) {
        if (inputStream == null) {
            return this.loadDOMInputSource(null, namespaceAware);
        }
        try {
            return this.loadDOMInputSource(new InputSource(inputStream), namespaceAware);
        }
        catch (Exception ex) {
            return this.loadDOMInputSource(null, namespaceAware);
        }
    }

    public Document inputStreamToDom(InputStream xmlSource) throws SAXException, ParserConfigurationException, IOException {
        return this.inputStreamToDom(xmlSource, true);
    }

    public Document inputStreamToDom(InputStream xmlSource, boolean isNamespaceAware) throws SAXException, ParserConfigurationException, IOException {
        return this.parseToDom(new InputSource(xmlSource), isNamespaceAware);
    }

    public Document stringToDom(String xmlSource) throws SAXException, ParserConfigurationException, IOException {
        return this.stringToDom(xmlSource, true);
    }

    public Document stringToDom(String xmlSource, boolean isNamespaceAware) throws SAXException, ParserConfigurationException, IOException {
        return this.parseToDom(new InputSource(new StringReader(xmlSource)), isNamespaceAware);
    }

    public Document parseToDom(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        return this.parseToDom(source, true);
    }

    public Document parseToDom(InputSource source, boolean isNamespaceAware) throws ParserConfigurationException, SAXException, IOException {
        this.factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        return builder.parse(source);
    }

    public <T> T xPathQuery(Node node, String xPathQuery, Class<T> clazz) throws XPathExpressionException {
        return this.xPathQuery(node, xPathQuery, null, clazz);
    }

    public <T> T xPathQuery(Node node, String xPathQuery, boolean forceNewSourceNode, Class<T> clazz) throws XPathExpressionException {
        return this.xPathQuery(node, xPathQuery, forceNewSourceNode, true, clazz);
    }

    public <T> T xPathQuery(Node node, String xPathQuery, boolean forceNewSourceNode, boolean isNamespaceAware, Class<T> clazz) throws XPathExpressionException {
        return this.xPathQuery(node, xPathQuery, null, forceNewSourceNode, isNamespaceAware, clazz);
    }

    public String domToString(Node node) throws UnsupportedEncodingException, TransformerFactoryConfigurationError, TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.printDom(node, ps);
        return baos.toString("UTF-8");
    }

    public <T> T xPathQuery(Node node, String xPathQuery, XPath xPath, Class<T> clazz) throws XPathExpressionException {
        return this.xPathQuery(node, xPathQuery, xPath, true, true, clazz);
    }

    public <T> T xPathQuery(Node node, String xPathQuery, XPath xPath, boolean forceNewSourceNode, Class<T> clazz) throws XPathExpressionException {
        return this.xPathQuery(node, xPathQuery, xPath, forceNewSourceNode, true, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T xPathQuery(Node node, String xPathQuery, XPath xPath, boolean forceNewSourceNode, boolean isNamespaceAware, Class<T> clazz) throws XPathExpressionException {
        Object object;
        Object nodeList = null;
        if (xPath == null) {
            xPath = XPathFactory.newInstance().newXPath();
        }
        if ("".equals(xPathQuery)) {
            return null;
        }
        Document sourceDOM = null;
        if (forceNewSourceNode) {
            try {
                sourceDOM = this.stringToDom(this.domToString(node), isNamespaceAware);
                sourceDOM.normalizeDocument();
            }
            catch (Exception e) {
                return null;
            }
        } else {
            sourceDOM = (Document)node;
        }
        try {
            XPathExpression xPathExpression = xPath.compile(xPathQuery);
            QName returnType = XPathConstants.NODESET;
            if (clazz.isAssignableFrom(NodeList.class)) {
                returnType = XPathConstants.NODESET;
            } else if (clazz.isAssignableFrom(Node.class)) {
                returnType = XPathConstants.NODE;
            }
            object = nodeList = xPathExpression.evaluate(sourceDOM, returnType);
        }
        catch (XPathExpressionException xpee) {
            if (this.throwExceptions) {
                throw xpee;
            }
            xpee.printStackTrace();
            return null;
        }
        return (T)object;
    }

    public String xPathLocalName(String xpath) {
        String[] xpathArray;
        StringBuilder localNameXPath = new StringBuilder();
        for (String xpathElement : xpathArray = xpath.split("/")) {
            if (xpathElement.isEmpty()) {
                localNameXPath.append("/");
                continue;
            }
            localNameXPath.append("/*[local-name()='").append(xpathElement).append("']");
        }
        localNameXPath.deleteCharAt(0);
        return localNameXPath.toString();
    }

    public void printDom(Node document, PrintStream printStream) throws TransformerFactoryConfigurationError, TransformerException {
        this.printDom(document, printStream, false);
    }

    public void printDom(Node document, PrintStream printStream, boolean indent) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = this.getTransformer();
        if (indent) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty(XML_APACHE_INDENT_AMOUNT, "2");
        }
        DOMSource source = new DOMSource(document);
        StreamResult output = new StreamResult(printStream);
        transformer.transform(source, output);
    }

    public Node getNode(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            return node;
        }
        return null;
    }

    public String transformForPost(Document doc) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = this.getTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("encoding", "UTF-8");
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(new DOMSource(doc), result);
        return result.getWriter().toString();
    }

    public Node addNode(Document dom, String nodeName, Map<String, String> attributes) {
        Element newNode = dom.createElement(nodeName);
        return this.addAttributes(newNode, attributes);
    }

    public Node addAttributes(Node node, Map<String, String> attributes) {
        if (attributes != null) {
            for (String attribute : attributes.keySet()) {
                Attr attributeNode = node.getOwnerDocument().createAttribute(attribute);
                attributeNode.setTextContent(attributes.get(attribute));
                node.getAttributes().setNamedItem(attributeNode);
            }
        }
        return node;
    }

    public Node copyChildNodes(Node origin, Node destiny) {
        if (origin.hasChildNodes()) {
            NodeList originChilds = origin.getChildNodes();
            for (int i = 0; i < originChilds.getLength(); ++i) {
                Node originNode = originChilds.item(i);
                destiny.appendChild(destiny.getOwnerDocument().importNode(originNode, true));
            }
        }
        return destiny;
    }

    public Node removeChildNodes(Node node) {
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                node.removeChild(childNode);
            }
        }
        return node;
    }

    public Node createNode(Node target, String nodeName) {
        return this.createNode(target, nodeName, null, null);
    }

    public Node createNode(Node target, String nodeName, String nodeText) {
        return this.createNode(target, nodeName, nodeText, null);
    }

    public Node createNode(Node target, String nodeName, Map<String, String> attributes) {
        return this.createNode(target, nodeName, null, attributes);
    }

    public Node createNode(Node target, String nodeName, String nodeText, Map<String, String> attributes) {
        Element node = null;
        node = Document.class.isInstance(target) ? ((Document)target).createElement(nodeName) : target.getOwnerDocument().createElement(nodeName);
        if (!"".equals(nodeText)) {
            node.setTextContent(nodeText);
        }
        if (attributes != null) {
            for (String attribName : attributes.keySet()) {
                Attr attribNode = node.getOwnerDocument().createAttribute(attribName);
                attribNode.setTextContent(attributes.get(attribName));
                node.getAttributes().setNamedItem(attribNode);
            }
        }
        target.appendChild(node);
        return node;
    }

    public void printToFile(String fileName, Node dom) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        File file = new File(fileName);
        this.printToFile(file, dom);
    }

    public void printToFile(File file, Node dom) throws FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        PrintStream writeToFile = new PrintStream(file);
        this.printDom(dom, writeToFile, true);
    }

    public XPath getXPathFromDOM(Document dom) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        DocumentNamespaceContext ctx = new DocumentNamespaceContext(dom);
        xpath.setNamespaceContext(ctx);
        return xpath;
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public Transformer getTransformer() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        if (this.transformer == null) {
            this.transformer = TransformerFactory.newInstance().newTransformer();
        }
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

